
## 4. Plan Metrics

The adoption of a stable numeric extension to the pddl **core allowed us to introduce a**
further extension into pddl2.1**, namely a new (optional) field within the specification of**
problems: a plan metric. Plan metrics specify, for the benefit of the planner, the basis on which a plan will be evaluated for a particular problem. The same initial **and goal** states might yield entirely different optimal plans given different plan **metrics. Of course,** a planner might not choose to use the metric to guide its development of a solution but just to evaluate a solution post hoc**. This approach might lead to sub-optimal, and possibly** even poor quality plans, but it is a pragmatic approach to the handling of metrics which was quite widely used in the competition. This issue is discussed further in the companion paper analysing the results of the 3rd IPC in this issue (Long & Fox, 2003b).

The value total-time **can be used to refer to the temporal span of the entire plan.**
Other values must all be built from primitive numeric expressions defined within a domain and manipulated by the actions of the domain. As a consequence, plan metrics can only express non-temporal metrics in pddl2.1 **domains using numeric expressions. Any arithmetic expression can be used in the specification of a metric - there is no requirement**
that the expression be linear. It is the domain designer's responsibility to ensure that plan metrics are well-defined (for example, do not involve divisions by zero). An example of use of a plan metric is shown in Figure 5.

The implications of having introduced this extension are far-reaching and have already helped to demonstrate some important new challenges for planning systems - **particularly** fully-automated systems. An enriched descriptive power for the evaluation **of plans is a**
crucial extension for the practical use of planners, since it is almost never the case that real plans are evaluated solely by the number of actions they contain.

Metrics are described in the problem description, allowing a modeller to easily explore the effect of different metrics in the construction of solutions to problems for the same domain. In order to define a metric in terms of a specific quantity it is necessary to instrument **that quantity in the domain description. For example, if the metric is defined in**
terms of overall fuel use a fuel-use **quantity can be initialised to zero in the initial state and** then updated every time fuel is consumed. In the domain shown in Figure 5 it is possible to minimise a linear combination of fuel used by each of the vehicles such as:
(:metric minimize (+ (* 2 (fuel-used car)) (fuel-used truck)))
However it is not possible to minimise distance covered since distance is not instrumented. It would be straightforward to instrument it if desired, simply by adding **the appropriate initial**
value and incrementing effects to the domain description. Since actions cause quantities to change, instrumenting a value requires modification of the domain description itself, not just a problem file.

The use of plan metrics is subtle and can have dramatic impact on the plans being sought. Perhaps the simplest case is where all actions increase a metric that **must be** minimised, or decrease one that must be maximised. This is the case in the example shown in Figure 5, where any use of the drive action can only worsen the value of the plan metric (whether we use the metric shown in the figure or the maximising metric described in the last paragraph). This situation might appear to be relatively straightforward: a planner