ordination in practical systems. These theories have inspired the construction of practical, domain-independent teamwork models and architectures (Jennings, 1995; Pynadath, Tambe, Chauvat, & Cavedon, 1999; Rich & Sidner, 1997; Tambe, 1997; Yen, Yin, Ioerger, Miller, Xu, & Volz, 2001), successfully applied in a range of complex domains.

Yet, two key shortcomings limit the scalability of these BDI-based theories and implementations. First, there are no techniques for the quantitative evaluation of the degree of optimality of their coordination behavior. While optimal teamwork may be impractical in real-world domains, such analysis would aid us in comparison of different theories/models and in identifying feasible improvements.  One key reason for the difficulty in quantitative evaluation of most existing teamwork theories is that they ignore the various uncertainties and costs in real-world environments. For instance, joint intentions theory (Cohen &
Levesque, 1991b) prescribes that team members attain mutual beliefs in key circumstances, but it ignores the cost of attaining mutual belief (e.g., via communication). Implementations that blindly follow such prescriptions could engage in highly suboptimal coordination. On the other hand, practical systems have addressed costs and uncertainties of real-world environments. For instance, STEAM (Tambe, 1997; Tambe & Zhang, 1998) extends joint intentions with decision-theoretic communication selectivity. Unfortunately, the very pragmatism of such approaches often necessarily leads to a lack of theoretical rigor, so it remains unanswered whether STEAM's selectivity is the best an agent can do, or whether it is even necessary at all. The second key shortcoming of existing teamwork research is the lack of a characterization of the computational complexity of various aspects of teamwork decisions. Understanding the computational advantages of a practical coordination prescription could potentially justify the use of that prescription as an approximation to optimality in particular domains.

To address these shortcomings, we propose a new complementary framework, the COM-
municative Multiagent Team Decision Problem (COM-MTDP), inspired by work in economic team theory (Marschak & Radner, 1971; Yoshikawa, 1978; Ho, 1980). While our COM-MTDP model borrows from a theory developed in another field, we make several contributions in applying and extending the original theory, most notably adding explicit models of communication and system dynamics. With these extensions, the COM-MTDP
generalizes other recently developed multiagent decision frameworks, such as decentralized POMDPs (Bernstein, Zilberstein, & Immerman, 2000).

Our definition of a team (like that in economic team theory) assumes only that team members have a common goal and that they work selflessly towards that goal (i.e., they have no other private goals of their own). In terms of our decision-theoretic framework, we assume that all of the team members share the same joint utility function—that is, each team member's individual preferences are exactly the preferences of the other members and, thus, of the team as a whole. Our definition may appear to be a "bare-bones" definition of a team, since it does not include common concepts and assumptions from the literature on what constitutes a team (e.g., the teammates form a joint commitment (Cohen & Levesque, 1991b), attain mutual belief upon termination of a joint goal, intend that teammates succeed in their tasks (Grosz & Kraus, 1996), etc.). From our COM-MTDP perspective, we view these concepts as more intermediate concepts, as the means by which agents improve their team's overall performance, rather than ends in themselves. Our hypothesis in this investigation is that our COM-MTDP-based analysis can provide concrete justifications for