# Towards Adjustable Autonomy For The Real World

## Paul Scerri David V. Pynadath Milind Tambe

Information Sciences Institute and Computer Science Department University of Southern California 4676 Admiralty Way, Marina del Rey, CA 90292 USA
SCERRIQISI EDU
PY NA DA TH Q ISI. E D U
TAMBEQUSC.EDU

## Abstract

Adjustable autonomy refers to entities dynamically varying their own autonomy, transferring decision-making control to other entities (typically agents transferring control to human users) in key situations. Determining whether and when such transfers-of-control should occur is arguably the fundamental research problem in adjustable autonomy. Previous work has investigated various approaches to addressing this problem but has often focused on individual agent-human interactions. Unfortunately, domains requiring collaboration between teams of agents and humans reveal two key shortcomings of these previous approaches. First, these approaches use rigid one-shot transfers of control that can result in unacceptable coordination failures in multiagent settings. Second, they ignore costs (e.g., in terms of time delays or effects on actions) to an agent's team due to such transfers-ofcontrol.

To remedy these problems, this article presents a novel approach to adjustable autonomy, based on the notion of a transfer-of-control strategy . A transfer-of-control strategy consists of a conditional sequence of two types of actions: (i) actions to transfer decisionmaking control (e.g., from an agent to a user or vice versa) and (ii) actions to change an agent's pre-specified coordination constraints with team members, aimed at minimizing miscoordination costs. The goal is for high-quality individual decisions to be made with minimal disruption to the coordination of the team. We present a mathematical model of transfer-of-control strategies. The model guides and informs the operationalization of the strategies using Markov Decision Processes, which select an optimal strategy, given an uccrtain environment and costs to the individuals and teams.  The approach has been carefully evaluated, including via its use in a real-world, deployed multi-agent system that assists a research group in its daily activities.

## 1. Introduction

Exciting, emerging application areas ranging from intelligent homes (Lesser et al., 1999), to routine organizational coordination (Pynadath et al., 2000), to electronic commerce (Collins et al., 2000), to long-term space missions (Dorais et al., 1998) utilize the decision-making skills of both agents and humans. These new applications have brought forth an increasing interest in agents' adjustable a utonomy (AA), i.e., in entities dynamically adjusting their own level of autonomy based on the situation (Mulsiner & Pell, 1999). Many of these exciting applications will not be deployed unless reliable AA reasoning is a central component. With A, an entity need not make all decisions autonomously; rather it can choose to reduce its own autonomy and transfer decision-making control to other users or agents, when doing so