cost that is a function of both the time, t, and the coordination constraints, ~, between team members. As stated earlier, we focus on cases of constraint violations due to delays in making decisions. Thus, the cost is due to the violation of the constraints caused by not making a decision until that point in time. We can write down a wait-cost function: W = f(x,t) which returns the cost of not making a decision until a particular point in time given coordination constraints, ~. This miscoordination cost is a fundamental aspect of our model given our emphasis on multiagent domains. It is called a "wait cost" because it models the miscoordination that arises while the team "waits" for some entity to make the ultimate decision. In domains like E-Elves, the team incurs such wait costs in situations where (for example) other meeting attendees have assembled in a meeting room at the time of the meeting, but are kept waiting without any input or decision from Friday (potentially because it cannot provide a high-quality decision, nor can it get any input from its user). Notice that different roles will lead to different wait cost functions, since delays in the performance of different roles will have different effects on the team.  We assume that there is some point in time, <!, after which no more costs accrue, i.e., if t > <! then f(~, t) = f(~,<). At the deadline, < , the maximum cost due to inappropriate timing of a decision has been incurred. Finally, we assume that, in general, until <!, the wait cost function is nondecreasing, reflecting the idea that bigger violations of constraints lead to higher wait costs.

The final element of the model is the coordination-change action, D, which moves the agent further away from the deadline and hence reduces the wait costs that are incurred. We model the effect of the D by letting W be a function of t - D vatue (rather than t ) after the D action and as having a fixed cost, Dcost, incurred immediately upon its execution. For example, in the E-Elves domain, suppose at the time of the meeting, Friday delays the meeting by 15 minutes ( D action). Then, in the following time period, it will incur the relatively low cost of not making a decision 15 minutes before the meeting ( t = Dystys);
rather than the relatively high cost of not making the decision at the time of the meeting.

Other, possibly more complex, models of a D action could also be used.

We use these four elements to compute the EU of an arbitrary strategy, s. The utility derived from a decision being made at time t by the entity in control is the quality of the entity's decision minus the costs incurred from waiting until t, i.e., EU d,(t) = EQ d,(t) = W(t). If a coordination-ange action has been taken it will also have an effect on utility. Until a coordination change of value Dvatue is taken at some time ∆ , the incurred wait cost is W(Δ). Then, between ∆ and t, the wait cost incurred is W(t − Dvatue) − W(Δ − Dvatue). Thus, if a D action has been taken at time ∆ for cost D cost and with value D value, the utility from a decision at time t ( t > ∆ ) is: EU ec ( t ) = EQ ec ( t ) − W(∆) − W(∆ − D vatue ) +
W(t - D vatue) - D cost . To calculate the EU of an entire strategy, we multiply the response probability mass function's value at each instant by the EU of receiving a response at that instant, and then integrate over the products. Hence, the EU for a strategy s given a problem instance, {A, α, ρ, χ, d, E}, is:

$$E U_{s}^{\left\langle A\right.\alpha,\rho,\left.\right.\right.\left.\right.\left.\right.\left.\right\left.\right\rangle}=\int_{0}^{\infty}P_{\top}(t)E U_{e_{c}}^{d}(t)\left.\right.d t$$
$$\left({2}\right)$$

If a strategy involves several actions, we need to ensure that the probability of response function and the wait-cost calculation reflect the control situation at that point in the strategy.  For example, if the user, H, has control at time t, P+(t) should reflect H's