The forbidding constraints are powerful enough for the entity to communicate a wide range of knowledge about their decision quality and probability of response to the agent. For instance, some E-Elves users have forbidden their agents from rescheduling meetings to lunch time. To do so, the users provide a feature specification of the states they want to forbid, such as meeting-time =12 PM. Such a specification generates a forbidden-state constraint, c fs , that is true in any state, s, where meeting-time =12 PM in s. This constraint effectively forbids the agent from performing any D action that would result in a state where meeting-time=12PM. Similarly, some users have forbidden autonomous actions in certain states by providing a specification of the actions they want to forbid, e.g., action = "ask" .

This generates a forbidden-action constraint, c to , that is true for any state/action pair,
(s, a), with a ≠"ask".  For example, a user might specify such a constraint for states where they are in their office, at the time of a meeting because they know that they will always make decisions in that case. Users can easily create more complicated constraints by specifying values for multiple features, as well as by using comparison functions other than = (e.g., ≠, >).

Analogous to the forbidding constraints, we also introduce required-state and requiredaction constraints, defined as sets, C rs and C rg , respectively. The interpretation provided to the required-state constraint is symmetric, but opposite to that of the forbidden-state constraint: Pr(s; $sf[P) = 1. Thus, from any state, the agent must eventually reach a required state, sf. Similarly, for the required-action constraint, Pr(s; $sfAP(sf)=a(P) = 1.

The users specify such constraints as they do for their forbidding counterparts (i.e., by specifying the values of the relevant state features or action, as appropriate). In addition, the requiring constraints also propagate backward. Informally, the forbidden constraints focus locally on specific states or actions, while the required constraints express global properties over all states.

The resulting language allows the agent to exploit synergistic interactions between its initial model of transfer-of-control strategies and entity-specified constraints. For example, a forbidden-action constraint that prevents the agent from taking autonomous action in a particular state is equivalent to the user specifying that the agent must transfer control to the user in that state. In AA terms, the user instructs the agent not to consider any transferof-control strategies that violate this constraint.  To exploit this pruning of the strategy space by the user, we have extended standard value iteration to also consider constraint sssees to the control of the strategic and the novel algorithm that finds optimal policies while respecting user constraints. The appendix also includes a proof of the algorithm's correctness.

## 5. Experimental Results

This section presents experimental results aimed at validating the claims made in the previous sections. In particular, the experiments aim to show the utility of complex transfer-ofcontrol strategies and the effectiveness of MDPs as a technique for their operationalization. Section 5.1 details the use of the E-Elves in daily activities and Section 5.2 discusses the pros and cons of living and working with the assistance of Fridays. Section 5.3 shows some characteristics of strategies in this type of domain (in particular, that different strategies