
## 6.  Related Work

We have discussed some related work in Section 1. This section adds to that discussion. In Section 6.1, we examine two representative AA systems - where detailed experimental results have been presented - and explain those results via our model. This illustrates the potential applicability of our model to other systems. In Section 6.2, we examine other AA
systems and other areas of related work, such as meta-reasoning, conditional planning and anytime algorithms.

## 6.1  Analyzing Other Aa Work Using The Strategy Model

Goodrich, Olsen, Crandall, and Palmer (2001) report on tele-operated teams of robots, where both the user's high-level reasoning and the robots' low-level skills are required to achieve some task. Within this domain, they have examined the effect of user neglect on robot performance. The idea of user neglect is similar to our idea of entities taking time to make decisions; in this case, if the user "neglects" the robot, the joint task takes longer to perform. In this domain, the coordination constraint is that user input must arrive so that the robot can work out the low-level actions it needs to perform. Four control systems were tested on the robot, each giving a different amount of autonomy to the robot, and the performance was measured as user neglect was varied.

Although quite distinct from the E-Elves system, mapping Goodrich's team of robots to our AA problem formulation provides some interesting insights. This system has the interesting feature that the entity the robot can call on for a decision, i.e., the user, is also part of the team. Changing the autonomy of the robot effectively changes the nature of the coordination constraints between the user and robot. Figure 16 shows the performance
(y-axis) of the four control policies as the amount of user neglect was increased (x-axis).

The experiments showed that higher robot autonomy allowed the operator to "neglect" the robot more without as serious an impact on its performance.

The notion of transfer-of-control strategies can be used to qualitatively predict the same behavior as was observed in practice, even though Goodrich et al. (2001) did not use the notion of strategies. The lowest autonomy control policy used by Goodrich et al. (2001) was a pure tele-operation one. Since the robot cannot resort to its own decision making, we represent this control policy with a strategy U, i.e., control indefinitely in the hands of the user. The second control policy allows the user to specify waypoints and on-board intelligence works out the details of getting to the waypoints. Since the robot has no highlevel decision-making ability, the strategy is simply to give control to the user. However, since the coordination between the robot and user is more abstract, i.e., the coordination constraints are looser, the wait cost function is less severe. Also the human is giving less detailed guidance than in the fully tele-operated case (which is not as good according to (Goodrich et al., 2001)), hence we use a lower value for the expected quality of the user decision. We denote this approach U wp to distinguish it from the fully tele-operated case. The next control policy allows the robot to choose its own waypoints given that the user inputs regions of interest. The robot can also accept waypoints from the user. The ability for the robot to calculate waypoints is modeled as a D, since it effectively changes the coordination between the entities, by removing the user's need to give waypoints.  We model this control policy as the strategy UDU . The final control policy is full autonomy, i.e., A.