
## Appendix  A:  An Example Instantiation Of The Model

In this Appendix, we present a detailed look at one possible instantiation of the AA model.

We use that instantiation to calculate the EU of commonly used strategies and show how that EU varies with parameters such as the rate of wait cost accrual and the time at which transfers of control are performed. In this instantiation, the agent, A, has only one entity to call on for a decision (i.e., the user U ), hence E = { A, U }. For W ( t ), we use the following function:

$${\cal W}(t)=\left\{\begin{array}{ll}\omega\exp^{\omega t}&t\leq\triangleleft\\ \omega\exp^{\omega}\triangleleft&\mbox{otherwise}\end{array}\right.\tag{15}$$

The exponential wait cost function reflects the idea that a big delay is much worse than a small one. A polynomial or similar function could have also been used but an exponential was used since it makes the mathematics cleaner. For the probability of response we use:
P t (t) = ρ exp-ρ t . A Markovian response probability reflects an entity that is just as likely to respond at the next point in time as they were at the previous point. For users moving around a dynamic environment, this turns out to be a reasonable approximation. The entities' decision-making quality is constant over time, in particular, EQ 2 ( t ) = α and for EQf,(t) = β. Assuming constant decision-making quality will not always be accurate in a dynamic environment since information available to an entity may change (hence influencing their ability to make the decision) however, for decisions involving static facts or preferences decision-making quality will be relatively constant. The functions are a coarse approximation of a range of interesting applications, including the E-Elves.  Table 7shows the resulting instantiated equations for the simple strategies (For convenience we let δ = ρ − ω). Figures 18(a) and (b) show graphically how the EU of the eA strategy varies along different axes (w is the parameter to the wait cost function, higher w means faster accruing wait costs and p is the parameter to the response probability function, higher p means faster response).

Notice how the EU depends on the transfer time (T) as much as it does on β (the user's decision quality). Figure 18(d) shows the value of a D (as discussed earlier).

Figure 18(c) compares the EU of the eDeA and estrategies. The more complex the transfer-of-control strategy (i.e., the more transfers of control it makes), the flatter the EU graph when plotted against wait cost ( w ) and response probability ( p ) parameters. In particular, the fall-off when the wait costs are high and the probability of response low is not so dramatic for the more complex strategy.

## Appendix B: Constraint Propagation Algorithm And Its Correctness

In Section 4.4, we examined the need for user-specified constraints in conjunction with our MDP-based approach to strategies. We must thus extend the standard MDP policy evaluation algorithms to support the evaluation of strategies while accounting for both the standard quantitative reward function and these new qualitative constraints.  This appendix provides the novel algorithm that we developed to evaluate strategies while accounting for