Walsh, 1998; Kirkpatrick & Selman, 1994; Mitchell, Selman, & Levesque, 1992; Vandegriend
& Culberson, 1998).

In this paper, we analyze the NK landscape model from the perspective of threshold phenomena and phase transitions.  We establish two random models for the decision problem of NK landscapes and study the threshold phenomena and the associated hardness of the phase transitions in these two models.

The rest of the paper is organized as follows. In Section 2, we introduce the NK fitness landscape and our probabilistic models, the uniform probability model and the fixed ratio model. In Section 3 and Section 4, the threshold phenomena and phase transitions in NK landscapes are analyzed. For the uniform probability model, we prove that the phase transition of the uniform probability model is easy in the sense that there is a polynomial algorithm that can solve a random instance of the problem with the probability asymptotic to 1 as the problem size tends to infinity. For the fixed ratio model, we establish two upper bounds for the solubility threshold, and prove that random instances with parameters above these upper bounds can be solved polynomially. This, together with our empirical study for random instances generated below and in the phase transition region, suggests that the phase transition of the fixed ratio model is also easy. In Section 5, we report our experimental results on typical hardness of the fixed ratio model. In Section 6, we conclude our investigation and discuss implications of our results.

## 2. Nk Landscapes And Their Probabilistic Models

An NK landscape f ( x ) = ∑ f i ( x i , Π( x i )), is a real-valued function defined on binary strings of fixed leng th, where n > 0 is a positive integer and x = ( x 1 , · · , x n ) ∈ {0 , 1} n . It is the sum of n local fitness functions f i , 1 ≤ i ≤ n . Each local fitness function f i ( x i , Π( x i )) depends on the main variable x i and its neighborhood Π( x i ) ⊂ P k ( { x 1 , ··· , x n }\{ x i }) where P k ( X )
denotes the set of all subsets of size k from X . The most important parameters of an NK
landscape are the number of variables n, and the size of the neighborhood k = | Π( x i ) .

In an NK landscape, the neighborhood Π( i ) can be chosen in two ways: the random nnneeeiiiibbborhood, where the k variables are randomly chosen from the set { x 1 , . . , x n }\{ x i },
and the adjacent neighborhood, where k variables with indices nearest to i (modulo n ) are chosen. For example, for any even integer k, the k variables in Π( x i ) can be defined as x((n+i-$) mod n)!     ! x((n+i+$) mod n). Once the variables in the neighborhood are determined, the local fitness function fi is determined by a fitness lookup table which specifies the function value f i for each of the 2 k +1 possible assignments to the variables x i and Π( x i ).

Throughout this paper, we consider NK landscapes with random neighborhoods. To simplify the discussion, we further assume that the local fitness functions take on binary values. Given an NK landscape f , the corresponding decision problem is stated as follows:
Is the maximum of f(x) equal to n? An NK landscape decision problem is insoluble if there is no solution for it.

It has been proved that the NK landscape model is NP complete for k ≥ 2 (e.g.,
Weinberger, 1996; Wright et al., 2000). The proofs were based on a reduction from SAT to the decision problem of NK landscapes. To study the typical hardness of the NK landscape decision problems in the framework of thresholds and phase transitions, we introduce two