Supporting factors are very important to achieve pattern descriptions that are reasonably complete and acceptable for medical practice, as medical experts dislike short rules and prefer rules including as much supportive evidence as possible (Kononenko, 1993).

In this work, the role of statistical analysis is to detect meaningful supporting factors, whereas the decision whether they will be used to support user's confidence in the subgroup description is left to the expert. In the CHD application the expert has decided whether the proposed factors are indeed interesting, how reliable they are or how easily they can be measured in practice. In Table 3, expert selected supporting factors are listed next to the individual CHD risk groups, each described by a list of principal factors.

| Principal Factors                    | Supporting Factors                |                               |
|--------------------------------------|-----------------------------------|-------------------------------|
| A 1                                  | positive family history           | psychosocial stress           |
| age over 46 year                     | cigarette smoking                 |                               |
| hypertension                         |                                   |                               |
| overweight                           |                                   |                               |
| A 2                                  | body mass index over 25 kgm       | positive family history       |
| age over 63 years                    | hypertension                      |                               |
| slightly increased LDL cholesterol   |                                   |                               |
| normal but decreased HDL cholesterol |                                   |                               |
| B l                                  | total cholesterol over 6.1 mmol L | increased triglycerides value |
| age over 53 years                    |                                   |                               |
| body mass index below 30 kgm –2      |                                   |                               |
| B2                                   | total cholesterol over 5.6 mmol L | positive family history.      |
| fibrinogen over 3.7 mmolL-1          |                                   |                               |
| body mass index below 30 kgm –2      |                                   |                               |
| C1                                   | left ventricular hypertrophy      | positive family history       |
| hypertension                         |                                   |                               |
| diabetes mellitus                    |                                   |                               |

Table 3: Induced subgroup descriptions (principal factors) and their statistical characteri-

zations (supporting factors).

## 3.4 Subgroup Visualization

A novel visualization method can be used to visualize the output of any subgroup discovery algorithm, provided that the output has the form of rules with a target class in their consequent. It can also be used as a method for visualizing standard classification rules.

Subgroup visualization, as described in this section, allows us to compare distributions of different subgroups. The approach assumes the existence of at least one numeric (or ordered discrete) attribute of expert's interest for subgroup analysis.  The selected attribute is plotted on the X-axis of the diagram. The Y-axis represents a class, or more precisely, the number of instances of a given class. Both directions of the Y-axis ( Y+ and Y- ) are used to indicate the number of instances. In Figure 6, for instance, the X-axis represents age , the Y +-axis denotes class coronary heart disease (CHD) and Y − denotes class 'healthy'