be of interest as subgroup descriptors with sufficient coverage. Subsequently induced rules are induced from biased example subsets, e.g., subsets including only positive examples not covered by previously induced rules. This bias constrains the population for subgroup discovery in a way that is unnatural for the subgroup discovery process which is, in general, aimed at discovering interesting properties of subgroups of the entire population.

Recent approaches to subgroup discovery aim at overcoming the problem of this inappropriate bias of the standard covering algorithm. The recently developed subgroup discovery algorithms CN2-SD (Lavrač, Flach, Kavšek, & Todorovski, 2002) and RSD (Lavrač, Zelezny, & Flach, 2002) use the so-called weighted covering algorithm, similar to the one implemented in Algorithm DMS described in this paper.

Instance weights play an important role in boosting (Freund & Shapire, 1996) and alternating decision trees (Schapire & Singer, 1999). Instance weights have been used also in variants of the covering algorithm implemented in rule learning approaches such as SLIPPER (Cohen, 1999), RL (Lee, Buchanan, & Aronis, 1998) and DAIRY (Hsu, Soderland, & Etzioni, 1998). A variant of the weighted covering algorithm has been used also in the context of confirmation rule subset selection (Gamberger & Lavrač, 2000), used as a basis for the rule subset selection algorithm RSS described in this paper.

## 5.2  Measures Of Interestingness

Various rule evaluation measures and heuristics have been studied for subgroup discovery, aimed at balancing the size of a group (referred to as factor g by Klösgen, 1996) with its distributional unusualness (referred to as factor p ). The properties of functions that combine these two factors have been extensively studied ( the so-called "p-g-space" ).

Similarly, the weighted relative accuracy heuristic, defined as WRAcc(Class ← Cond) =
p(Cond) · (p(Class|Cond) - p(Class)) and used by Todorovski, Flach, and Lavrač (2000),
trades off generality of the rule ( p ( Cond ), i.e., rule coverage) and relative accuracy p( Class Cond ) - p ( Class ). This heuristic is a reformulation of one of the measures used in EXPLORA.

Besides such 'objective' measures of interestingness, some 'subjective' measure of interestingness of discovered patterns can be taken into the account, such as actionability ('a pattern is interesting if the user can do something with it to his or her advantage') and unexpectedness ("a pattern is interesting to the user if it is surprising to the user") (Silberschatz & Tuzhilin, 1995).

## 5.3   Subgroup  Evaluation  Measures

Evaluation of induced subgroups in the ROC space (Provost & Fawcett, 2001) shows classifier performance in terms of false alarm or false positive rate FPr = T H FFF (plotted on the X -axis) that needs to be minimized, and sensitivity or true positive rate TPr = TPTEN
(plotted on the Y-axis) that needs to be maximized. The ROC space is appropriate for measuring the success of subgroup discovery, since subgroups whose TPr/FPr tradeoff is close to the diagonal can be discarded as insignificant. An appropriate approach to evaluating a set of induced subgroups is by using the area under the ROC convex hull defined by subgroups with the best TPr/FPr tradeoff as a quality measure for comparing the success of different learners.