Alternatives to the area under the ROC convex hull computation are other standard evaluation measures used in rule learning, such as predictive accuracy or, in the case of time/efficiency constraints that need to be taken into the account, the tradeoff measures DEA (Keller, Paterson, & Berrer, 2000) and Adjusted Ratio of Ratios (ARR) (Brazdil, Soares, & Pereira, 2001) that combine accuracy and time to assess relative performance.

Optimized accuracy is, however, not the ultimate goal of subgroup discovery.  In addition to the area under the ROC convex hull quality measure, other important success measures are rule significance (measuring the distributional unusualness of a subgroup), rule coverage
(measuring how large is a discovered subgroup), rule size and size of a rule set (measuring the simplicity and understandability of discovered knowledge). These measures were used to evaluate the results of the CN2-SD subgroup discovery algorithm (Lavrač et al., 2002).

## 5.4 Subgroup Visualization

Data visualization methods have been part of statistics and data analysis research for many years. This research concentrated primarily on plotting one or more independent variables against a dependent variable in support of exploratory data analysis (Tukey, 1977; Lee, Ong, & Quek, 1995; Unwin, 2000).

The visualization of analysis results has, however, gained only recently some attention with the proliferation of data mining (Card, Mackinlay, & Shneidermann, 1999; Fayyad, Grinstein, & Wierse, 2002; Keim & Kriegel, 1996; Simoff, Noirhomme-Fraiture, & Boehlen, 2001). The visualization of analysis results primarily serves four purposes: better illustrate the pattern to the end user, enable the comparison of patterns, increase pattern acceptance, and enable pattern editing and support for "what-if questions".  The recent interest in the visualization of analysis results was spawned by the often overwhelming number and complexity of data mining results.

Readers interested in comparing the visualization method proposed in this paper with other subgroups visualization methods can find the visualization of subgroups A1–C1 in the joint work by Gamberger, Lavrač, and Wettschereck (2002).

## 6. Conclusions

This paper presents a novel subgroup discovery algorithm integrated into the end to end knowledge discovery process. The discussion and empirical results point out the importance of effective expert-guided subgroup discovery in the TP/FP space. Its main advantages are the possibility to induce knowledge at different levels of generalization (achieved by tuning the g parameter of the subgroup discovery algorithm) used in the rule quality measure that ensures the induction of high quality rules also in the heuristic subgroup discovery process. The paper argues that expert's involvement in the induction process is necessary for successful actionable knowledge generation.

The proposed expert-guided subgroup discovery process consists of the following steps:
problem understanding, data understanding and preparation, subgroup discovery, subgroup subset selection, statistical characterization of subgroups, subgroup visualization, their interpretation and evaluation. The main steps, described in detail in this paper, are subgroup discovery and the selection of a subset of diverse subgroups, followed by the statistical characterization of subgroups that adds supporting factors to the induced subgroup descriptions.