
## 2.2 The Subgroup Discovery Algorithm

The goal of the subgroup discovery algorithm SD, outlined in Figure 1, is to search for rules that maximize q 9 = FP+g ; where TP are true positives, FP are false positives, and g is a generalization parameter. High quality rules cover many target class examples and a low nmber of non-target examples. The number of tolerated non-target class cases, relative to the number of covered target class cases, is determined by parameter g. For low g ( g ≤ 1),
induced rules will have high specificity (low false alarm rate) since covering of every single n-target class example is made relatively very 'expensive'.  On the other hand, by selecting a high g value ( g > 10 for small domains), more general rules will be generated, covering also non-target class instances.

Algorithm SD: Subgroup Discovery Input: E = P U N (E training set, I E I training set size, P positive (target class) examples, N negative (non-target class) examples)
L set of all defined features (attribute values), l ∈ L
Parameter: g (generalization parameter, 0.1 < g, default value 1)
min_support (minimal support for rule acceptance)
beam width (maximal number of rules in Beam and New Beam)
Output: S = { TargetClass ← Cond } (set of rules formed of beam width best conditions Cond )
(1)    for all rules in Beam and New Beam (i = 1 to beam width ) do initialize condition part of the rule to be empty, Cond(i) ← {}
initialize rule quality, q ( i ) ← 0
(2)     while there are improvements in Beam do for all rules in Beam (i = 1 to beam width) do
(3)
for all l ∈ L do
(4)

form a new rule by forming a new condition as a conjunction of the
(5)
condition from Beam and feature l, Cond(i) ← Cond(i) Al compute the quality of a new rule as q g = FP+ g
(6)

if ̸= min support and if  q g is larger than any g ( i ) in New Beam
(7)
and if  the new rule is relevant do
(8)
replace the worst rule in New Beam with the new rule and reorder the rules in New Beam with respect to their quality end for features
(9)
(10)

end for rules from Beam
(11)
Beam ← New Beam
(12) end while Figure 1: Heuristic beam search rule construction algorithm for subgroup discovery.

Varying the value of g enables the expert to guide subgroup discovery in the TP/FP
space, in which FP (plotted on the X-axis) needs to be minimized, and TP (plotted on the Y-axis) needs to be maximized. The TP/FP space is similar to the ROC (Receiver Operating Characteristic) space (Provost & Fawcett, 2001). The comparison of the ROC and TP/FP space and the gg heuristic are analyzed in detail in Sections 2.4 and 4, respectively.