Algorithm SD takes as its input the complete training set E and the feature set L,
where features l E L are logical conditions constructed from attribute values describing the examples in E . For discrete (categorical) attributes, features have the form Attribute =
value or Attribute ≠ value , for numerical attributes they have the form Attribute > value or Attribute < value. To formalize feature construction, let values vix ( x = 1. kip ) denote the kip different values of attribute Aj that appear in the positive examples and wjy (y = 1. k in ) the k in different values of A i appearing in the negative examples. A set of features L is constructed as follows:
- For discrete attributes Ai, features of the form Ai = vix and Ai / wiy are generated.

- For continuous attributes A i , similar to Fayyad and Irani (1992), features of the form Ai < (vix + wiy)/2 are created for all neighboring value pairs (vix, wiy), and features A i > ( vix + wiy )/2 for all neighboring pairs ( wiy, vix ).

- For integer valued attributes Ai, features are generated as if Ai were both discrete and continuous, resulting in features of four different forms:  Ai  < ( vix + wiy )/2, Ai > (vix + wiy)/2, Ai = vix, and Ai ≠ wiy
There is no theoretical upper value for the user-refined g parameter, but in practice the suggested upper limit should not exceed the number of training examples. For instance, suggested g values in the Data Mining Server are in the range between 0.1 and 100, for analysing data sets of up to 250 examples. The oice of g should be adjusted both to the size of the data set and to the proportion of positive examples in the set.

Algorithm SD has two additional parameters which are typically not adjusted by the user. The first is min_support (default value is √ P/E, where P is the number of target class examples in E ) which indirectly defines the minimal number of target class examples which must be covered by every subgroup. The second is beam width (default value is 20) which defines the number of solutions kept in each iteration. The output of the algorithm is set S of beam width different rules with highest q a values. The rules have the form of conjunctions of features from L .

The algorithm initializes all the rules in Beam and New beam by empty rule conditions.

Their quality values q 0 (i) are set to zero (step 1). Rule initialization is followed by an infinite loop (steps 2–12) that stops when, for all rules in the beam, it is no longer possible to further improve their quality. Rules can be improved only by conjunctively adding features from L. After the first iteration, a rule condition consists of a single feature, after the second iteration up to two features, and so forth. The search is systematic in the sense that for all rules in the beam (step 3) all features from L (step 4) are tested in each iteration. For every new rule, constructed by conjunctively adding a feature to rule body (step 5) quality q is computed (step 6). If the support of the new rule is greater than min_support and if its quality q is greater than the quality of any rule in New_beam, the worst rule in New_beam is replaced by the new rule. The rules are reordered in New_beam according to their quality q g . At the end of each iteration, New beam is copied into Beam (step 11).

When the algorithm terminates, the first rule in Beam is the rule with maximum q .

A necessary condition (in step 7) for a rule to be included in New_beam is that it must be relevant. The new rule is irrelevant if there exists a rule R in New beam such that true positives of the new rule are a subset of true positives of R and false positives of the new rule