Input to Algorithm RSS are the set of all target class examples P and the set of rules S. Its output is a reduced set of rules SS, SS ⊂ S. The user adjustable parameter number determines how many rules will be selected for inclusion in output set SS. For every example e E P there is a counter c(e). Initially, the output set of selected rules is empty (step 1)
and all counter values are set to 1 (step 2). Next, in each iteration of the loop (steps 3 to 8), one rule is added to the output set (step 7). From set S, the rule with the highest weight value is selected. For each rule, weight is computed so that 1/c(e) values are added for all target class examples covered by this rule (step 4). After rule selection, the rule is eliminated from set S (step 6) and c(e) values for all target class examples covered by the selected rule are incremented by 1 (step 5). This is the central part of the algorithm which ensures that in the first iteration all target class examples contribute the same value 1/c(e) = 1 to the weight, while in the following iterations the contributions of examples are inverse proportional to their coverage by previously selected rules. In this way the examples already covered by one or more selected rules decrease their weights while rules covering many yet uncovered target class examples whose weights have not been decreased will have a greater chance to be selected in the following iterations.

In the publicly available Data Mining Server, RSS is implemented in an outer loop for SD. Figure 3 gives the pseudo code of algorithm DMS. In its inner loop, DMS calls SD and selects from its beam the single best rule to be included into the output set SS. To enable SD to induce a different solution at each iteration, example weights c( e ) are introduced and used in the quality measure which is defined as follows:

$$q_{g}\,=\,\frac{\sum_{T P}\,\frac{1}{c(e)}}{F P\,+\,g}.$$

This is the same quality measure as in SD except that the weights of true positive examples are not constant and equal to 1 but defined by expression cfc , changing from iteration to iteration.

The main reason for the described implementation is to ensure the diversity of induced subgroups even though, because of the short execution time limit on the publicly available server, a low beam width parameter value in Algorithm SD had to be set (the default value is 20). Despite the favorable diversity of rules achieved through Algorithm DMS, the approach has also some drawbacks. The first drawback is that the same rule can be detected in different iterations of Algorithm DMS, despite of the changes in the c( e ) values.  The more important drawback is that heuristic search with a small beam width value may prevent the detection of some good quality subgroups. Therefore during exploratory applications, applying a single SD execution with a large beam width followed by a single run of RSS
appears to be a better approach.

## 2.4  Subgroup Search And Evaluation In The Roc And Tp/Fp Space

The goal of this section is to clarify the relation between the ROC space which is usually used for evaluating classifier performance, and the TP/FP space which is being searched by the q o heuristic in the SD algorithm.

Evaluation of induced subgroups in the ROC space (ROC: Receiver Operating Characteristic, Provost & Fawcett, 2001) shows their performance in terms of TPr and FPr,