
## 3.3  Complexity Results

While syntactical FL and FV-dependence can be easily checked in linear time in the size of the input, this is far from being expected for (semantical) FL-dependence and FV- dependence in the general case:
Proposition 10 (complexity of FL/FV-dependence) FL DEPENDENCE, FV DEPEN- DENCE, FULL FL DEPENDENCE and FULL FV DEPENDENCE are NP-complete.

Thus, although they look simple, the problems of determining whether a formula is independent from a literal or a variable are as hard as checking propositional entailment.

Interestingly, the complexity of both decision problems fall down to P whenever checking
(in)dependence becomes tractable. Apart from the case of syntactical independence, some other restrictions on Σ makes (in)dependence testable in polynomial time. Especially, we get:
Proposition 11   Whenever Σ belongs to a class C of CNF formulas that is tractable for clausal query answering (i.e., there exists a polytime algorithm to determine whether Σ |= γ for any CNF formula γ) and stable for variable instantiation (i.e., replacing in Σ ∈ C any variable by true or by false gives a formula that still belongs to C) then FL DEPENDENCE,
FV DEPENDENCE, FULL FL DEPENDENCE and FULL FV DEPENDENCE are in P.

In particular, when Σ is restricted to a renamable Horn CNF formula or to binary clauses (Krom formula), all four decision problems above belong to P.

We have also investigated the complexity of checking whether a formula is Lit-simplified
(and Var-simplified):
Proposition 12 LIT-SIMPLIFIED FORMULA and VAR-SIMPLIFIED FORMULA are NP-complete.

All these complexity results have some impact on the approaches that explicitly need computing DepVar(E) as a preprocessing task. Namely, we have the following result:

## Proposition 13

1. Determining whether DepLit(Σ) = L (where L is a set of literals), and determining

whether DepVar(E) = X (where X is a set of variables) is BH2-complete.

2. The search problem consisting in computing DepLit(Σ) (respectively DepVar(Σ)) is in FA 2 and is both NP-hard and coNP-hard.

## 3.4 Discussion

The previous characterizations and complexity results lead to several questions: when is it worthwhile to preprocess a knowledge base by computing independence relations? How should these independence relations be computed? What is the level of generality of the definitions and results we gave in this section?