The fact that both notions of formula-variable independence and forgetting have been used as key concepts in many AI fields (including automated reasoning, belief revision and update, diagnosis, reasoning about actions etc.) has been discussed before (Sections 1 and 4), so we will refrain from repeating it here. The gain of generality offered by the corresponding literal-oriented notions introduced in this paper has also been established (e.g., Proposition 20), and their application to several AI problems (like closed-world reasoning and belief update) has been sketched.

Primarily, one of the main motivations for the notions of formula-variable independence and forgetting was to improve inference from a computational side, by enabling to focus on relevant pieces of knowledge. The extent to which this goal can be reached can be discussed at the light of our complexity results:
- Most (in) dependence relations have a high complexity. The notions connected to FV-
dependence (FL-dependence, full FV- and FL-dependence, influenceability, relevance to a subject matter and strict relevance second form) have a complexity at the first level of the polynomial hierarchy, which means that they can be checked by a satisfiability or/and an unsatisfiability solver. They become "tractable" when syntactical restrictions are made (Proposition 11). Forgetting (literals or variables) also is computationally expensive. The remaining notions are in complexity classes located at the second level of the polynomial hierarchy. Worse, under the standard assumptions of complexity theory, the explicit computation of literal or variable forgetting cannot be achieved in polynomial space in the general case (Proposition 23). This pushes towards the negative conclusion that all these notions are hard to be computed (at least in the worst case) except if the size or the syntactical form of the input enables it. The fact that these problems fall in the second level of the polynomial hierarchy are not that surprising since this is where a large part (if not the majority) of important problems in knowledge representation 7 fall.

- But a high worst-case complexity does not necessarily prevent from practical algorithms! Thus, Amir and McIlraith have shown the computational benefits that can be achieved by structuring a KB (through the forgetting operation) so as to achieve
inference and consequence finding more efficiently (Amir & McIlraith, 2000; McIlraith & Amir, 2001). A similar discrepancy between the worst case situation and the practical ones can be observed in other domains; especially, satisfiability-based checkers for quantified boolean formulas (Biere, Cimatti, Clarke, Fujita, & Zhu, 1999; Williams, Biere, Clarke, & Gupta, 2000) used for formal verification purposes (bounded model checking) exhibit interesting computational behaviours (actually, they typically perform better than specialized algorithms, as shown in Rintanen, 2001), despite the fact that they are confronted to the problem of variable forgetting (i.e., elimination of existentially quantified variables).