
## 2. Preliminaries

We first recall some basic notions from propositional logic, and from complexity theory.

## 2.1   Propositional Logic

Let PS be a finite set of propositional variables. PROPpS is the propositional language built up from PS, the connectives and the Boolean constants true and false in the usual way. For every V ⊆ PS, PROPv denotes the sublanguage of PROPps generated from the variables of V only. A literal of PROPv is either a variable of V (positive literal) or the negation of a variable of V (negative literal). Their set is denoted L V , while L ‡ (resp. L V )
denotes the set of positive (resp. negative) literals built up from V. A clause 6 (resp. a term γ ) of PROP v is a (possibly empty) finite disjunction (resp. conjunction) of literals of PV. A CNF (resp. a DNF) formula of PROPV is a finite conjunction of clauses (resp. disjunction of terms) of PROP V . As usual, every finite set of formulas from PROP P S is identified with the formula that is the conjunction of its elements.

From now on, Σ denotes a propositional formula, i.e., a member of PROPps. Var(Σ) is the set of propositional variables appearing in E. If L E L P S, V ar ( L ) is the set of variables from PS upon which literals of L are built. Elements of PS are denoted v, x, y etc.

Elements of L PS are denoted l, l 1 , l 2 etc. Subsets of PS are denoted V, X, Y etc. In order to simplify notations, we assimilate every singleton V = { v } with its unique element v . The size of a formula Σ , denoted by | Σ |, is the number of occurrences of variables it contains. A
propositional formula Σ is said to be in Negation Normal Form (NNF) if and only if only propositional symbols are in the scope of an occurrence of ¬ in Σ . It is well-known that every propositional formula Σ built up from the connectives ∧ , ∨ ¬ ⇒ only, can be turned in linear time into an equivalent NNF formula by "pushing down" every occurrence of ¬ in it (i.e., exploiting De Morgan's law) and removing double negations (since ¬ is involutive).

Slightly abusing words, we call the formula resulting from this normalization process the NF of Σ and we note Lit (Σ) the set of literals from L P S occurring in the NNF of Σ. For instance, the NNF of Σ = ¬((¬a^b)Vc) is (aV¬b)A¬c; hence, we have Lit(Σ) = {a,¬b,¬c}.

Note that the NNF of a formula depends on its syntactical structure, i.e., two formulae that are synctatically different may have different NNFs even if they are equivalent.

Full instantiations of variables of V ⊆ PS are called V-worlds 1 ; they are denoted by w and their set is denoted Ω v . When A and B are two disjoint subsets of PS, ω A Λω B
denotes the AUB-world that coincides with ω A on A and with ω B on B . An interpretation ω over PROP S is just a PS -world, and ω is said to be a model of Σ whenever it makes Σ true. We denote Mod(Σ) the set of models of Σ.

For every formula Σ and every variable x, Σ x ← 0 (resp. Σ x ← 1 ) is the formula obtained by replacing every occurrence of x in Σ by the constant false (resp. true). Σ l ← 1 (resp.

Et ← 0 ) is an abbreviation for Σ x ← 1 (resp. Σ x ← 0 ) when l is a positive literal x and for Σ x ← 0
(resp. Ex~1) when l is a negative literal -x.

Given an interpretation ω and a literal l, we let Force( ω,l ) denote the interpretation that gives the same truth value as ω to all variables except the variable of l , and such that Force(w,l) |= l. In other words, Force(w,l) is the interpretation satisfying l that is 1. The V-worlds are also called partial models over V.