This is a combinatorial optimization problem: we seek the maximum of a function p ( γι: κ | yo: κ )
that associates a number with each of the discrete configurations γ 1 : κ . Since it is not feasible to visit all of the exponentially many configurations to find the maximizing configuration Y i : K i we will resort to stochastic search algorithms such as simulated annealing (SA) and iterative improvement (II). Due to the strong relationship between the Gibbs sampler and SA (or II), we will first review the Gibbs sampler for the switching state space model.

The first important observation is that, conditioned on γι:κ, the model becomes a linear state space model and the integration on z 0 : K can be computed analytically using Kalman filtering equations.  Consequently, one can sample only γ 1: κ and integrate out z .

The analytical marginalization, called Rao-Blackwellization (Casella & Robert, 1996), improves the efficiency of the sampler (e.g., see Doucet, de Freitas, Murphy, & Russell, 2000a).

Suppose now that each switch variable γ k can have S distinct states and we wish to generate N samples (i.e trajectories) { γ (j) , i = 1 . . N } . A naive implementation of the Gibbs sampler requires that at each step k we run the Kalman filter S times on the whole observation sequence yo:K to compute the proposal p( γk | γ | x − 1 , γ k + 1 , κ , γ 0:K )  This would result in an algorithm of time complexity O( NK 2 S ) that is prohibitively slow when K is large.  Carter and Kohn (1996) have proposed a much more time efficient deterministic scan Gibbs sampler that circumvents the need to run the Kalman filtering equations at each step k on the whole observation sequence y 0 ; K . See also (Doucet & Andrieu, 2001; Murphy, 2002).

The method is based on the observation that the proposal distribution p ( γ k | · ) can be factorized as a product of terms that either depend on past observations yo k or the future observations y k +1: K . So the contribution of the future can be computed a-priori by a backward filtering pass.  Subsequently, the proposal is computed and samples γ [j] are generated during the forward pass. The sampling distribution is given by

$$p\big(\gamma_{k}\,\big|\,\gamma_{-k}\,,\,y_{0:K}\big)\propto p\big(\gamma_{k}\,\big|\,\gamma_{-k}\,\big)p\big(y_{0:K}\big|\gamma_{1:K}\big)$$
$$(17)$$

where the first term is proportional to the joint prior p( γ k | γ - k ) ∞ p( γ k ; γ - k ). The second term can be decomposed as

$$p\big{(}y_{0:K}\big{|}\gamma_{1:K}\big{)}=\int dz_{k}p\big{(}y_{k+1:K}\big{|}y_{0:k}\,,\,z_{k}\,,\,\gamma_{1:K}\big{)}p\big{(}y_{0:k}\,,\,z_{k}\,\big{|}\gamma_{1:K}\big{)}\tag{1}$$ $$=\int dz_{k}p\big{(}y_{k+1:K}\big{|}z_{k}\,,\,\gamma_{k+1:K}\big{)}p\big{(}y_{0:k}\,,\,z_{k}\,\big{|}\gamma_{1:k}\big{)}\tag{1}$$
$$\left(\,1\,8\right)$$  $$\left(\,1\,9\right)$$

Both terms are (unnormalized) Gaussian potentials hence the integral can be evaluated analytically. The term p ( yk + 1 : K 1 zk ; Yk + 1 : K ) is an unnormalized Gaussian potential in zk and can be computed by backwards filtering. The second term is just the filtering distribution p( zk Yo:k; 71:k ) scaled by the likelihood p ( yo:k [ 71:k ) and can be computed during forward filtering. The outline of the algorithm is given below, see the appendix B.1 for details.

$1.\,$ Initialize $\gamma^{[0\,]}_{1:K}$ b. 
1. Initialize γ (0) by sampling from a proposal q (γι:κ)

 $\text{2.For}i\,=\,1\,\hdots\,N$ . 
* For $k=K-1$, $\cdot\cdot\cdot$, $0$,