Given a sequentially constructed proposal distribution, one can compute the importance weight recursively as

(26)
The sequential update schema is potentially more accurate than naive importance sampling since at each step k, one can generate a particle from a fairly accurate proposal distribution that takes the current observation yk into account. A natural choice for the proposal distribution is the filtering distribution given as

$$q(x_{k}\left|x_{0:k-1}^{(i)}y_{0:k}\right.)=p(x_{k}\left|x_{0:k-1}^{(i)},y_{0:k}\right.)\tag{27}$$

In this case the weight update rule in Eq. 26 simplifies to

$$\begin{array}{r c l}{{w_{k}^{(i\,)}}}&{{=}}&{{p\bigl(y_{k}\,|x_{0\,;k\,-\,1}^{(i\,)}\bigr)w_{k\,-\,1}^{(i\,)}}}\end{array}$$

In fact, provided that the proposal distribution q is constructed sequentially and past sampled trajectories are not updated, the filtering distribution is the optimal choice in the sense of minimizing the variance of importance weights w ( i ) (Doucet, Godsill, & Andrieu, 2000b).

Note that Eq. 27 is identical to the proposal distribution used in Gibbs sampling at k = K (Eq 15). At k < K, the SMC proposal does not take future observations into account; so we introduce discount factors w k to compensate for sampling from the wrong distribution.

## 3.3.3 Selection

Unfortunately, the sequential importance sampling may be degenerate, in fact, it can be shown that the variance of w 1 i increases with k . In practice, after a few iterations of the algorithm, only one particle has almost all of the probability mass and most of the computation time is wasted for updating particles with negligible probability.

To avoid the undesired degeneracy problem, several heuristic approaches are proposed in the literature.  The basic idea is to duplicate or discard particles according to their normalized importance weights. The selection procedure can be deterministic or stochastic. Deterministic selection is usually greedy; one chooses N particles with the highest importance weights. In the stochastic case, called resampling, particles are drawn with a probability proportional to their importance weight w (i). Recall that normalized weights
{w{i} i = 1 . . . N } can be interpreted as a discrete distribution on particle labels (i).

## 3.4  Smc For The Switching State Space Model

The SIS algorithm can be directly applied to the switching state space model by sampling directly from x k = ( z k ; Y k ). However, the particulate approximation can be quite poor if z