Monte Carlo (MCMC) and sequential Monte Carlo (SMC) to approximate the respective distributions.

The quantization model we propose is similar to that of (Raphael, 2001a). For transcription, Raphael proposes to compute arg max p (co: K, zo: K | yo: K ) and uses a message propagation scheme that is essentially analogous to Rao-Blackwellized particle filtering. To prevent the number of kernels from explosion, he uses a deterministic selection method, called
"thinning". The advantage of Raphael's approach is that the joint MAP trajectory can be computed exactly, provided that the continuous hidden state z is one dimensional and the model is in a parameter regime that keeps the number of propagated Gaussian kernels limited, e.g., if R is small, thinning can not eliminate many kernels. One disadvantage is that the number of kernels varies depending upon the features of the filtering distribution; it is difficult to implement such a scheme in real time. Perhaps more importantly, simple extensions such as increasing the dimensionality of z or introducing nonlinearities to the transition model would render the approach quickly invalid. In contrast, Monte Carlo methods provide a generic inference technique that allow great flexibility in models one can employ.

We have tested our method on a challenging artificial problem (clave example).  SMC
has outperformed MCMC in terms of the quality of solutions, as measured in terms of the likelihood as well as the edit distance. We propose the use of SMC for both problems. For finding the MAP quantization, we propose to apply iterative improvement (II) to the SMC solution on the reduced configuration space.

The correct choice of the score prior is important in the overall performance of the ssssem. Most music pieces tend to have a certain rhythmical vocabulary, that is certain rhythmical motives reoccur several times in a given piece. The rhythmic structure depends mostly upon the musical genre and composer. It seems to be rather difficult to devise a general prior model that would work well in a large spectrum of styles. Nevertheless, for a given genre, we expect a simple prior to capture enough structure sufficient for good transcription. For example, for the Beatles dataset, we have estimated the prior by counting from the original score of "Yesterday". The statistics are fairly close to that of "Michelle".

The good results on the test set can be partially accounted for the fact that both pieces have a similar rhythmical structure.

Conditioned on the score, the tempo tracking model is a linear dynamical system.  We have optimized several tempo models using EM where we have varied the dimension of tempo variables z . The test results suggest that increasing the dimensionality of z improves the likelihood. However, increase in the likelihood of the whole dataset does not translate directly to overall better quantization results (as measured by edit distance). We observe that models trained on the whole training data fail consistently for some subjects, especially professional classical pianists.  Perhaps interestingly, if we train "custom" models specifically optimized for the same subjects, we can improve results significantly also on test cases.

This observation suggests a kind of multimodality in the parameter space where modes correspond to different performer regimes. It seems that a Kalman filter is able to capture the structure in expressive timing deviations. However, when averaged over all subjects, these details tend to be wiped out, as suggested by the quantization results that do not vary significantly among models of different dimensions.