A related problem with the edit distance measure is that under an "average" model, the likelihood of the desired score (e.g., original score of "Michelle") may have a lower likelihood than a solution found by an inference method. In such cases increasing the likelihood may en decrease the edit distance. In some test cases we even observe solutions with a higher likelihood than the original notation where all notes are wrong. In most of these cases, the tempo trajectory of the solution correspond to the half or twice of the original tempo so consequently all note durations are halved or doubled (e.g., all whole notes are notated as half notes, all half notes as quarters e.t.c.). Considering the fact that the model is "self initializing" its tempo, that is we assume a broad uncertainty a-priori, the results are still satisfactory from a practical application perspective.

One potential shortcoming of our model is that it takes only timing information of onsets into account. In reality, we believe that pitch and melodic grouping as well as articulation (duration between note onsets and offsets) and dynamics (louder or softer) provide useful additional information for tempo tracking as well as quantization. Moreover, current model assumes that all onsets are equally relevant for estimation. That is probably in general not true: for example, a kick-drum should provide more information about the tempo than a flute.  On the other hand, our simulations suggest that even from such a limited model one can obtain quite satisfactory results, at least for simple piano music.

It is somewhat surprising, that SMC, basically a method that samples from the filtering distribution outperforms an MCMC method such as SA that is specifically designed for finding the MAP solution given all observations. An intuitive explanation for relatively poorer MCMC results is that MCMC proceeds first by proposing a global solution and then tries to improve it by local adjustments. A human transcriber, on the other hand, would listen to shorter segments of music and gradually write down the score. In that respect, the sequential update schema of SMC seems to be more natural for the rhythm transcription problem. Similar results, where SMC outperforms MCMC are already reported in the literature, e.g., in the so-called "Growth Monte Carlo" for generating self-avoiding random walks (Liu, Chen, & Logvinenko, 2001). It seems that for a large class of dynamical problems, including rhythm transcription, sequential updating is preferable over batch methods.

We note that theoretical convergence results for SA require the use of a logarithmic cooling schedule. It seems that our cooling schedule was too fast to meet this requirement; so one has to be still careful in interpreting the poor performance as a negative SA result.

We maintain that by using a richer neighborhood structure in the configuration space (e.g., by using a block proposal distribution) and a slower cooling schedule, SA results can be improved significantly.  Moreover, MCMC methods can be also be modified to operate sequentially, for example see (Marthi, Pasula, Russell, & Peres, 2002).

Another family of inference methods for switching state space models rely on deterministic approximate methods. This family includes variational approximations (Ghahramani & Hinton, 1998) and expectation propagation (Heskes, 2002). It remains an interesting open question whether deterministic approximation methods provide an advantage in terms of computation time and accuracy; in particular for the quantization problem and for other switching state space models. A potential application of the deterministic approximation techniques in a MCMC schema can be in designing proposal distributions that extend over several time slices. Such a schema would circumvent the burden for computing the optimal proposal distribution exhaustively hence allowing more global moves for the sampler.