quantization methods proposed in the literature either estimate the tempo using simple heuristics (Longuet-Higgins, 1987; Pressing & Lawrence, 1993; Agon, Assayag, Fineberg, & Rueda, 1994) or assume that the tempo is known or constant (Desain & Honing, 1991; Cambouropoulos, 2000; Hamanaka, Goto, Asoh, & Otsu, 2001).

Our approach to transcription and tempo tracking is from a probabilistic, i.e., Bayesian modeling perspective. In Cemgil et al. (2000), we introduced a probabilistic approach to perceptually realistic quantization. This work also assumed that the tempo was known or was estimated by an external procedure. For tempo tracking, we introduced a Kalman filter model (Cemgil, Kappen, Desain, & Honing, 2001).  In this approach, we modeled the tempo as a smoothly varying hidden state variable of a stochastic dynamical system.

In the current paper, we integrate quantization and tempo tracking.  Basically, our model balances score complexity versus smoothness in tempo deviations.  The correct tempo interpretation results in a simple quantization and the correct quantization results in a smooth tempo fluctuation.  An essentially similar model is proposed recently also by Raphael (2001a). However, Raphael uses an inference technique that only applies for small models; nmely when the continuous hidden state is one dimensional. This severely restricts the models one can consider. In the current paper, we survey general and widely used state-ofthe-art techniques for inference.

The outline of the paper is as follows: In Section 2, we propose a probabilistic model for timing deviations in expressive music performance.  Given the model, we will define tempo tracking and quantization as inference of posterior quantities.  It will turn out that our model is a switching state space model in which computation of exact probabilities becomes intractable. In Section 3, we will introduce approximation techniques based on simulation, nmely Markov Chain Monte Carlo (MCMC) and sequential Monte Carlo (SMC) (Doucet, de Freitas, & Gordon, 2001; Andrieu, de Freitas, Doucet, & Jordan, 2002).  Both approaches provide flexible and powerful inference methods that have been successfully applied in diverse fields of applied sciences such as robotics (Fox, Burgard, & Thrun, 1999), aircraft traing (Gordon, Salmond, & Smith, 1993), computer vision (Isard & Blake, 1996), econometrics (Tanizaki, 2001). Finally we will present simulation results and conclusions.

## 2. Model

Assume that a pianist is improvising and we are recording the exact onset times of each key she presses during the performance. We denote these observed onset times by yo, y 1 , y 2 . . Yk . . . YK or more compactly by yo:K. We neither have access to a musical notation of the piece nor know the initial tempo she has started her performance with.  Moreover, the pianist is allowed to freely change the tempo or introduce expression.  Given only onset time information yo:K, we wish to find a score 71:K and track her tempo fluctuations zo:K. We will refine the meaning of γ and z later.

This problem is apparently ill-posed. If the pianist is allowed to change the tempo arbitrarily it is not possible to assign a "correct" score to a given performance. In other words any performance yo:K can be represented by using a suitable combination of an arbitrary score with an arbitrary tempo trajectory. Fortunately, the Bayes theorem provides an elegant and principled guideline to formulate the problem. Given the onsets yo: κ , the best score γ 1 : κ and tempo trajectory z 0 : κ can be derived from the posterior distribution