allow for scores that have sixteenth notes and triplets, we define a table of probabilities for the states c_mod 1 = {0, 0.25, 0.5, 0.75} ∪ {0, 0.33, 0.67}. Technically, the resulting prior p(c k ) is periodic and improper (since c k are in principle unbounded so we can not normalize the distribution).

However, if the number of states of ck mod 1 is large, it may be difficult to estimate the parameters of the prior reliably. For such situations we propose a "generic" prior as follows: We define the probability, that the k 'th onset gets quantized at location c k , by p(c k ) ∞
exp( − λ d(c k )) where d(c k ) is the number of significant digits in the binary expansion of c k mod 1. For example d (1) = 0, d (1.5) = 1, d (7 + 9/32) = 5 etc. The positive parameter λ is used to penalize quantization locations that require more bits to be represented. Assuming that quantization locations of onsets are independent a-priori, (besides being increasing in k, i.e., ck ≥ ck–1 ), the prior probability of a sequence of quantization locations is given by p(c 0 : K ) ∞ exp( − λ ∑ k = 0 d(c k )). We further assume that c 0 ∈ [0 , 1). One can check that such a prior prefers simpler notations, e.g., p ( RRI ) < p ( JJ ). We can generalize this prior to other subdivisions such triplets and quintiplets in Appendix A.

Formally, given a distribution on c 0 : K , the prior of a score γ 1 : K is given by

$$p{\big(}\gamma_{1:K}{\big)}=\sum_{c_{0:K}}p{\big(}\gamma_{1:K}{\big|}c_{0:K}{\big)}p{\big(}c_{0:K}{\big)}$$
$$\left({2}\right)$$

Since the relationship between c 0 : K and γ 1 : K is deterministic, p (γ 1 : K | c 0 : K ) is degenerate for any given co:K, so we have

$$p(\gamma_{1:K})\propto\exp\left(-\lambda\sum_{k\,=\,1}^{K}d(\sum_{k^{\prime}\,=\,1}^{k}\gamma_{k^{\prime}})\right)$$
$$\left({\mathfrak{J}}\right)$$

One might be tempted to specify a prior directly on γ 1 : κ and get rid of c 0 : κ entirely.

However, with this simpler approach it is not easy to devise realistic priors. For example, consider a sequence of note durations [ 1 1/16 1 1 1 . . ]. Assuming a factorized prior on y that penalizes short note durations, this rhythm would have relatively high probability whereas it is quite uncommon in conventional music.

## 2.2 Tempo Prior

We represent the tempo in terms of its inverse, i.e., the period, and denote it with ∆. For example a tempo of 120 beats per minute (bpm) corresponds to △ = 60/120 = 0.5 seconds.

At each onset the tempo changes by an unknown amount ζ ∆ ∗ . We assume the change ζ ∆ ∗
is iid with N (0, Q ∆ ). ² We assume a first order Gauss-Markov process for the tempo

$$\begin{array}{r c l}{{\Delta_{k}}}&{{=}}&{{\Delta_{k-1}\,+\,\zeta_{\Delta_{k}}}}\end{array}$$
$$\left({\boldsymbol{4}}\right)$$

Eq. 4 defines a distribution over tempo sequences Ao;K. Given a tempo sequence, the
"ideal" or "intended" time τ k of the next onset is given by

$$\tau_{k}$$
$$\begin{array}{r l}{={}}&{{}\tau_{k\,-1}\,+\,\gamma_{k}\,\Delta_{k\,-1}\,+\,\zeta_{\tau_{k}}}\end{array}$$
$$\left({\bar{5}}\right)$$
