In our dynamical system framework such smooth deviations can be modeled by increasing the dimensionality of z to include higher order "inertia" variables (Cemgil et al., 2001).  For example consider the following model,

![0_image_0.png](0_image_0.png)

We choose this particular parameterization because we wish to interpret ∆ 1 as the slowly varying "average" tempo and ∆ 2 as a temporary change in the tempo.  Such a model is useful for situations where the performer fluctuates around an almost constant tempo; a random walk model is not sufficient in this case because it forgets the initial values. Additional state variables ∆ 3, . . . , ∆ D –1 act like additional "memory" elements. By choosing the parameter matrix A and noise covariance matrix Q , one can model a rich range of temporal structures in expressive timing deviations.

The score prior can be improved by using a richer model.  For example to allow for different time signatures and alternative rhythmic subdivisions, one can introduce additional hidden variables (See Cemgil et al. (2000) or Appendix A) or use a Markov chain (Raphael, 2001a).  Potentially, such extensions make it easier to capture additional structure in musical rhythm (such as "weak" positions are followed more likely by "strong" positions). On the other hand, the number of model parameters rapidly increases and one has to be more cautious in order to avoid overfitting.

For score typesetting, we need to quantize note durations as well, i.e., associate note offsets with quantization locations. A simple way of accomplishing this is to define an indicator sequence uo:K that identifies whether yk is an onset ( uk = 1) or an offset ( uk =
0).  Given u k , we can redefine the observation model as p ( y k | τ k , u k ) = u k N (0, R ) + (1 −
u ) N (0, R off ) where R off is the observation noise associated with offsets.  A typical model would have Roff ≫ R. For Roff → ∞, the offsets would have no effect on the tempo process.

Moreover, since uk are always observed, this extension requires just a simple lookup.

In principle, one must allow for arbitrary long intervals between onsets, hence γ k are drawn from an infinite (but discrete) set. In our subsequent derivations, we assume that the nmber of possible intervals is fixed a-priori.  Given an estimate of z k _ 1 and observation y k ,
almost all of the virtually infinite number of choices for γ k will have almost zero probability and it is easy to identify candidates that would have significant probability mass.

Conceptually, all of the above listed extensions are easy to incorporate into the model and none of them introduces a fundamental computational difficulty to the basic problems of quantization and tempo tracking.