
## 2.4 Problem Definition

Given the model, we define rhythm transcription, i.e., quantization as a MAP state estimation problem

$$\left({\mathfrak{g}}\right)$$
$$\gamma_{1:K}^{*}=\mathop{\rm argmax}_{\gamma_{1:K}}p(\gamma_{1:K}|y_{0:K})$$ $$p\big{(}\gamma_{1:K}|y_{0:K}\big{)}=\int dz_{0:K}p\big{(}\gamma_{1:K},\,z_{0:K}|y_{0:K}\big{)}$$

and tempo tracking as a filtering problem

$$z_{k}^{*}=\underset{z_{k}}{\operatorname{argmax}}\sum_{\gamma_{1:k}}p(\gamma_{1:k},z_{k}\left|y_{0:k}\right.)\tag{10}$$

The quantization problem is a smoothing problem: we wish to find the most likely score Y i , K given all the onsets in the performance.  This is useful in "offline" applications such as score typesetting.

For real-time interaction, we need to have an online estimate of the tempo/beat zk.

This information is carried forth by the filtering density p( γι: k, zk | yo: k ) in Eq.10.  Our definition of the best tempo z k as the maximum is somewhat arbitrary. Depending upon the requirements of an application, one can make use of other features of the filtering density. For example, the variance of E 71 , k P ( 71 , k , zk , yo: k ) can be used to estimate "amount of confidence" in tempo interpretation or arg max z k, 71 : k P( 71 : k, zk | yo: k) to estimate most likely score-tempo pair so far.

Unfortunately, the quantities in Eq. 9 and Eq. 10 are intractable due to the explosion in the number of mixture components required to represent the exact posterior at each step k
(See Figure 2). For example, to calculate the exact posterior in Eq. 9 we need to evaluate the following expression:

$$p\big{(}\gamma_{1:K}|y_{0:K}\big{)}=\frac{1}{Z}\int dz_{0:K}p\big{(}y_{0:K}|z_{0:K},\gamma_{1:K}\big{)}p\big{(}z_{0:K}|\gamma_{1:K}\big{)}p\big{(}\gamma_{1:K}\big{)}$$ $$=\frac{1}{Z}p\big{(}y_{0:K}|\gamma_{1:K}\big{)}p\big{(}\gamma_{1:K}\big{)}$$  where the normalization constant is given by $Z=p\big{(}y_{0:K}\big{)}=\sum_{\gamma_{1:K}}p\big{(}y_{0:K}|\gamma_{1:K}\big{)}p\big{(}\gamma_{1:K}\big{)}$. For 
$$\left(\,1\,1\,\right)$$  $$\left(\,1\,2\,\right)$$

each trajectory 71:K; the integral over zo:K can be computed stepwise in k by the Kalman filter (See appendix B.1). However, to find the MAP state of Eq. 11, we need to evaluate p ( yo: κ [ γι: κ ) independently for each of the exponentially many trajectories. Consequently, the quantization problem in Eq. 9 can only be solved approximately.

For accurate approximation, we wish to exploit any inherent independence structure of the exact posterior. Unfortunately, since z and c are integrated over, all γ k become coupled and in general p ( γ 1 : κ | γ 0 : κ ) does not possess any conditional independence structure (e.g.,
a Markov chain) that would facilitate efficient calculation. Consequently, we will resort to numerical approximation techniques.

## 3. Monte Carlo Simulation

Consider a high dimensional probability distribution

$$p\left(\mathbf{x}\right)={\frac{1}{Z}}p\,^{*}(\mathbf{x})$$
$$\left(13\right)$$
