is contextually independent of its predecessors given the context defined by a path through the tree.

The paths through the tree correspond to parent contexts.

Before showing how the structure of parent contexts can be exploited in inference, there are a few properties to note:

- The elements of a mutually exclusive and exhaustive set of parent contexts are not always the minimal parent contexts. For example, suppose we have a variable A with parents B and C,
all of which are Boolean. Suppose probability of a is p1 when both B and C are true and probability p2 otherwise. One mutually exclusive and exhaustive set of parent contexts for A is {b ∧ c, b ∧ c, b}. b ∧ c is not minimal as c is also a parent context. Another mutually exclusive and exhaustive set of parent contexts for this example is {b ∧ c, b ∧ c, c}. The set of minimal parent contexts, {b ∧ c, b, c}, isn't a mutually exclusive and exhaustive set as the elements are not pairwise incompatible.

One could imagine using arbitrary Boolean formulae in the contexts. This was not done as it would entail using theorem proving (or a more sophisticated subsumption algorithm) during inference. We doubt that this would be worth the extra overhead for the limited savings.

- A compact decision tree representation of conditional probability tables (Boutilier et al., 1996)
always corresponds to a compact set of parent contexts (one context for each path through the tree). However, a mutually exclusive and exhaustive set of parent contexts cannot always be directly represented as a decision tree (as there isn't always a single variable to split on). For example, the mutually exclusive and exhaustive set of contexts{{a, b},{a, c},{b, c},{a, b, c},{a, b, c}}
doesn't directly translate into a decision tree. More importantly, the operations we perform don't necessarily preserve the tree structure. Section 4.12 shows how we can do much better than an analogous tree-based formulation of our inference algorithm.
Definition 8 A **contextual belief network** is an acyclic directed graph where the nodes are random variables. Associated with each node Xiis a mutually exclusive and exhaustive set of parent contexts,
-i, and, for each π ∈ -i, a probability distribution P(Xi|π ) on Xi. Thus a contextual belief network is like a belief network, but we only specify the probabilities for the parent contexts.

For each variable Xi and for each assignment Xi−1=vi−1, . . . , X1=v1 of values to its preceding variables, there is a compatible parent context π vi−1...v1 Xi. The probability of a complete context (an assignment of a value to each variable) is given by:
P(X1=v1, . . . , Xn=vn)

$$\mathbf{\partial}\cdot\mathbf{\partial},\mathbf{\partial}\chi_{n}-\nu_{n}\rangle$$
=n i=1 P(Xi=vn|Xi−1=vi−1, . . . , X1=v1) =n i=1 P(Xi=vi|π vi−1...v1
Xi) (2)
This looks like the definition of a belief network (equation (1)), but which variables act as the parents depends on the values. The numbers required are the probability of each variable for each element of the mutually exclusive and exhaustive set of parent contexts. There can be many fewer of these than the number of assignments to parents in a belief network. At one extreme, there are the same number; at the other extreme there can be exponentially many more assignments of values to parents than the number of elements of a mutually exclusive and exhaustive set of parent contexts.

$$\left(2\right)$$
