
## 3.3 Parent Skeletons

Although the definition of a contextual belief network specifies the contextual independence we want, it doesn't give us a way to organize the parent contexts (in much the same way as a belief network doesn't specify the representation of a conditional probability table). We use the concept of a parent skeleton as a way to organize the parent contexts; we want to use the indexing provided by tables while still allowing for the ability to express context-specific independence.

The notion of a parent context is more fine-grained than that of a parent (the set of parents corresponds to many parent contexts). When there is no context-specific independence, we would like to not have to consider the parent contexts explicitly, but consider just the parents. We will use a parent skeleton to cover both parents and parent contexts as special cases, and to interpolate between them, when the independence depends on some context as well as all values of some other variables.

Definition 9 A **parent skeletal pair** for variable X is a pair -c, V where c is a context on the predecessors of X and V is a set of predecessors of X such that X is contextually independent of its predecessors given V and context c. Note that a parent context is c ∧ V = v. A **parent skeleton** for variable X is a set of parent skeletal pairs, {cj, Vj: 0 < j ≤ k}, where the cj are mutually exclusive and exhaustive (i.e., ci and cj are incompatible if i 
= j, and k j=1 cj ≡ *true*).

Example 10 A parent skeleton for E from Example 9 is {-a,{B}, -a ∧ c,{}, -a ∧ c ∧ d,{B},
a ∧ c ∧ d,{}.

Parent skeletons form the basis of a representation for contextual belief networks. For each variable, X, you select a parent skeleton such that for each parent skeleton pair cj, Vjin the parent context, cj ∧ Vj = vjis a parent context for X. For each such parent context pair we specify a probability distribution P(X|cj ∧ Vj = vj).

## 3.4 Contextual Factors

Whereas the VE algorithm uses tables both as a representation for conditional probabilities and for the intermediate representations, the contextual variable elimination algorithm defined below uses a hybrid of tables and rules (Poole, 1997) that we call contextual factors or confactors. Confactors cover both tables and rules as special cases.

## Definition 10 A Contextual Factor Or Confactor Is A Pair Of The Form: -C, T

where c is a context, say X1=vk ∧ . . . ∧ Xk=vk , and t is a table that represents a function on variables Xk+1, . . . , Xm, where {X1, . . . , Xk } and {Xk+1, . . . , Xm} are disjoint sets of variables. c is called the body of the confactor and t is called the **table** of the confactor.

A confactor represents a partial function (Zhang and Poole, 1999) from the union of the variables.

The function only has a value when the context is true, and the value of the function is obtained by looking up the value in the table.

Just as tables can be used to represent conditional probabilities, confactors can be used to represent conditional probabilities when there is context-specific independence. In particular, a set of parent contexts can be represented as a set of confactors with mutually exclusive and exhaustive bodies.

Given a parent skeleton for variable X we can construct a set of confactors for X as follows: for each
-c, V in the parent skeleton for X, we construct a confactor -c, t({X} ∪ V) where t({X = x} ∧ V =
v) = P(X = x|V = v ∧ c).