Definition 11 A confactor is **applicable** on a context if the body of the confactor is compatible with the context.

Definition 12 Given a confactor r = -X1=vk ∧ . . . ∧ Xk=vk , t[Xk+1, . . . , Xm] and a context c that assigns at least the variables X1 . . . Xm, if r is applicable in c, the **value** of the context c with respect to the confactor r is the value of t[Xk+1 = vk+1, . . . , Xm = vm] where vk+1, . . . , vm are the values assigned to Xk+1, . . . , Xm in c. Definition 13 A set R of confactors **represents a conditional probability** P(Xi|X1 . . . Xi−1) if the bodies of the confactors are mutually exclusive and exhaustive, and if P(Xi = vi|X1 = v1 ∧ . . . ∧
Xi−1 = vi−1) is equal to the value of the context X1 = v1 ∧ . . . ∧ Xi−1 = vi−1 ∧ Xi = vi with respect to the (unique) confactor in R that is applicable in that context.

Intuitively, the confactors that represent a contextual belief network are a way to organize the parent contexts. The idea is to represent the parent contexts in tables when there is no context-specific independence, and when some variables are independent of their predecessors in some context, then that context can be made a body of the confactors.

Example 11 Consider the conditional probabilities represented in Figure 3. E is independent of its predecessors given {B} and context a. This leads to the confactor:
-a, t1[B, E] (3)
E is independent of its predecessors given context a ∧ c. This leads to the confactor:
-a ∧ c, t2[E] (4)
E is independent of its predecessors given {B} and context a ∧ c ∧ D. This leads to the confactor:
-a ∧ c ∧ d, t3[B, E] (5)
E is independent of its predecessors given context a ∧ c ∧ d. This leads to the confactor:
-a ∧ c ∧ d, t4[E] (6)
The full multiset of confactors corresponding to the trees of Figure 3 are given in Figure 4. The fifth and sixth confactors give the conditional probability for B, and the last two confactors give the conditional probability for D.

We can now rewrite the definition of a contextual belief network in terms of confactors:
If every conditional probability is represented by a set of confactors, the probability of a complete context, c is the product of the values of c with respect to the confactors that are applicable in c. For each complete context and for each variable there is one confactor containing that variable that is applicable in that context.

## 4. Contextual Variable Elimination

The general idea of contextual variable elimination (CVE) is to represent conditional probabilities in terms of confactors, and use the VE algorithm with the confactor representation rather than with tables. The units of manipulation are thus finer grained than the factors in VE or the members of the buckets of BEBA; what is analogous to a factor or a member of a bucket consists of multisets of confactors. Given a variable to eliminate, we can ignore (distribute out) all of the *confactors*that don't