Example 13 Splitting the first confactor for P(B|Y, Z) in Figure 4 on A gives two confactors:

a ∧ y,

$$\left({\overline{{a}}}\wedge y,\right)$$

| B     | Z     | Value   |
|-------|-------|---------|
| true  | true  | 0.77    |
| true  | false | 0.17    |
| false | true  | 0.23    |
| false | false | 0.83    |
| B     | Z     | Value   |
| true  | true  | 0.77    |
| true  | false | 0.17    |
| false | true  | 0.23    |
| false | false | 0.83    |


(9)  $$\begin{array}{l}\mbox{(10)}\end{array}$$ . 


The reason that we may want to do these two splits is that now we can multiply confactors (7) and
(9).

## 4.5 Examples Of Eliminating Variables

The four operations above are all that is needed to eliminate a variable. A variable is eliminated when it is summed out of all contexts.

Example 14 When we eliminate B from the confactors of Figure 4, we only need to consider the four confactors that contain B. The preconditions for summing out B or for multiplying are not satisfied, so we need to split. If we split the first confactor for P(E|A, B,C, D) on Y (as in Example 12) and split the first confactor for P(B|Y, Z) on A (as in Example 13), we produce two confactors,
(7) and (9), that can be multiplied producing:

$$\left[\,a\wedge y,\right.$$

B E Z *Value*

true true true 0.4235

true true false 0.0935

true false true 0.3465

true false false 0.0765

false true true 0.069

false true false 0.249

false false true 0.161

false false false 0.581

$$(11)$$

This is the only confactor that contains B and is applicable in the context a ∧ y, so we can sum out B from the table, producing the confactor:

E Z Value
true true 0.4925
true false 0.3425
false true 0.5075
false false 0.6575

$$(12)$$
The other nontrivial confactors produced when summing out B are:

$$\begin{array}{l}{\overline{{\left.{\begin{array}{l}{V a l u e}\\ {0.3675}\end{array}}\right\}}}\\ {\overline{{\left.{\begin{array}{l}{0.6325}\end{array}}\right\}}}\end{array}$$
$\boxed{\frac{E}{true}}\\ \\ \boxed{\frac{true}{false}}$

$$\left(a\wedge{\overline{{y}}},\right)$$

E *Value*
true 0.3675
false 0.6325

$$(13)$$
a ∧ y,