for efficient inference in belief networks can be extended to also exploit contextual independence.

Poole (1997) provides an earlier, less efficient, version in terms of rules. Zhang and Poole (1999)
give an abstract mathematical analysis of how contextual independence can be exploited in inference.

Section 2 introduces belief networks and an algorithm, variable elimination (VE) (Zhang and Poole, 1994) or Bucket Elimination for belief assessment (Dechter, 1996), for computing posterior probabilities in belief that is based on nonlinear dynamic programming (Bertelè and Brioschi, 1972).

Section 3 presents a representation for conditional probabilities that lets us state contextual independence in terms of *confactors*. Section 4 shows how the VE algorithm can be extended to exploit the contextual independence in confactors. Section 5 shows how we can improve efficiency by reducing the amount of splitting. Section 6 gives some empirical results on standard and random networks. The details of the experiments are given in Appendix A. Section 7 gives comparisons to other proposals for exploiting contextual independencies. Section 8 presents conclusions and future work.

## 2. Background

In this section we present belief networks and an algorithm, variable elimination, to compute the posterior probability of a set of query variables given some evidence.

## 2.1 Belief Networks

We treat random variables as primitive. We use upper case letters to denote random variables. The domain of a random variable X, written dom(X), is a set of values. If X is a random variable and v ∈ dom(X), we write X=v to mean the proposition that X has value v. The function dom can be extended to tuples of variables. We write tuples of variables in upper-case bold font. If X is a tuple of variables, -X1, . . . , Xk , then dom(X) is the cross product of the domains of the variables. We write -X1, . . . , Xk  = -v1, . . . , vk  as X1 = v1 ∧ . . . ∧ Xk = vk . This is called an instantiation of X.

For this paper we assume there is a finite number of random variables, and that each domain is finite.

We start with a total ordering X1, . . . , Xn of the random variables.

Definition 1 The **parents** of random variable Xi, written πXi
, are a minimal1set of the predecessors of Xiin the total ordering such that the other predecessors of Xi are independent of Xi given πXi
. That is πXi ⊆ {X1, . . . , Xi−1} such that P(Xi|Xi−1 . . . X1) = P(Xi|πXi
).

A **belief network** (Pearl, 1988) is an acyclic directed graph, where the nodes are random variables2. We use the terms node and random variable interchangeably. There is an arc from each element of πXi into Xi. Associated with the belief network is a set of probabilities of the form P(X|πX), the conditional probability of each variable given its parents (this includes the prior probabilities of those variables with no parents).

By the chain rule for conjunctions and the independence assumption:
P(X1, . . . , Xn) =n i=1 P(Xi|Xi−1 . . . X1)