- Else if c 
⊆ c1, select a variable X that is assigned in c but not in c1.

_residual_($r_{1}$, $c$) $=$ {$\langle c_{1}\wedge X$=$v_{i}$, $set(t_{1},X$=$v_{i})\rangle:v_{i}\in dom(X)\&v_{i}\neq c^{X}$} $\cup residual(\langle c_{1}\wedge X$=$c^{X},set(t_{1},X$=$c^{X})\rangle,c)$
where c Xis the value assigned to X in context c. Recall (Definition 2) that set(t, X=vi) is t if t doesn't involve X and is the selection of the X=vi values from the table, followed by the projection onto the remaining variables, if t does involve X.

The results of splitting a confactor on a context is a set of confactors:
split(-c1, t1, c) = *residual*(-c1, t1, c) **∪ {-**c1 ∪ c, t1}.

Example 16 Consider *residual*(-a ∧ b, t1[C, D], c ∧ e). Suppose we split on C first, then on E.

This results in two residual confactors: -a ∧ b ∧ c, t2[D] and -a ∧ b ∧ c ∧ e, t3[D]. Note that t2[D]
is the projection of t1[C, D] onto C=*false* and t3[D] is the projection of t1[C, D] onto C=*true*. The non-residual confactor that we want from the split is -a ∧ b ∧ c ∧ e, t3[D].

If instead we split on E then C, we get the residual confactors: -a ∧ b ∧ e, t1[C, D] and
-a ∧ b ∧ c ∧ e, t2[D], with the same non-residual confactor.

Note that the result can depend on the order in which variables are selected (see below for some useful splitting heuristics). The algorithms that use the split will be correct no matter which order the variables are selected, however some orderings may result in more splitting in subsequent operations.

Example 16 highlights one heuristic that seems generally applicable. When we have to split a confactor on variables that appear in its body and on variables in its table, it's better to split on variables in the table first, as these simplify the confactors that need to be subsequently split.

We can use the notion of a residual to split two rules that are compatible, and need to be multiplied.

Suppose we have confactors r1 = -c1, t1 and r2 = -c2, t2, that both contain the variable being eliminated and where c1 and c2 are compatible contexts. If we split r1 on c2, and split r2 on c1, we end up with two confactors whose contexts are identical. Thus we have the prerequisite needed for multiplying.

Example 17 Suppose we have confactors r1 = -a ∧ b ∧ c, t1 and r2 = -a ∧ d, t2 that both contain the variable being eliminated. We can split r1 on the body of r2, namely a ∧ d, producing the confactors
-a ∧ b ∧ c ∧ d, t1 (31)
-a ∧ b ∧ c ∧ d, t1 Only the first of these is compatible with r2. The second confactor is a residual confactor.

We can split r2 on the body of r1, namely a∧b∧c, by first splitting r2 on B, then on C, producing the confactors:
-a ∧ b ∧ c ∧ d, t2
-a ∧ b ∧ c ∧ d, t2 (32)
-a ∧ b ∧ d, t2 Only the second confactor (confactor (32))is compatible with r1 or any of the residual confactors produced by splitting r1. Confactors (31) and (32) have identical contexts and so can be multiplied.

$\eqref{eq:walpha}$