Suppose we have confactors r1 = -c1 ∧ Y=vi, t1 and r2 = -c2 ∧ Y=vj, t2, where c1 and c2 are compatible contexts, and vi 
= vj. If we split r1 on c2, and split r2 on c1, we end up with two confactors whose contexts are identical except for the complementary values for Y. This is exactly what we need for summing out Y.

If Y is binary with domain {vi, vj}, and there are confactors r1 = -c1 ∧ Y=vi, t1 and r2 =
-c2 ∧Y=vj, t2, where c1 and c2 are compatible contexts, and there is no other confactor that contains Y that is compatible with c1 and c2, summing out Y in the context c1 ∪ c2 results in the confactors:
residual(r1, c2) ∪ *residual*(r2, c1) **∪ {-**c1 ∪ c2, t1 ⊕tt2}.

If there are more than two values in the domain, we may need to split each pair of confactors, always using the results of previous splits for subsequent splits.

Proposition 1 Splitting confactor -c1, t1 on c creates
-
X∈vars(c)−*vars*(c1)
(|dom(X)| − 1)
extra confactors, independently of the order in which the variables are selected to be split, where vars(c) is the set of variables assigned in context c.

When we have to split, there is a choice as to which variable to split on first. While this choice does not influence the number of confactors created for the single split, it can influence the number of confactors created in total because of subsequent splitting. One heuristic was given above. Another useful heuristic seems to be: given a confactor with multiple possible splits, look at all of the confactors that need to be combined with this confactor to enable multiplication or addition, and split on the variable that appears most. For those cases where the conditional probability forms a tree structure, this will tend to split on the root of the tree first.

## 4.7 Evidence

As in VE, evidence simplifies the knowledge base. Suppose E1=o1 ∧ . . .∧Es=osis observed. There are three steps in absorbing evidence:
- Remove any confactor whose context contains Ei=o
′
i
, where oi 
= o
′
i
.

- Remove any term Ei=oiin the context of a confactor.

- Replace each table t with set(t, E1=o1 ∧ . . . ∧ Es=os) (as in the tabular VE algorithm).
Again note that incorporating evidence only simplifies the confactor base.

Once evidence has been incorporated into the confactor-base, the **program invariant** becomes:
The probability of the evidence conjoined with a context c on the non-eliminated, nonobserved variables is equal to the product of the probabilities of the confactors that are applicable in context c. For each context c on the non-eliminated, non-observed variables and for each variable X there is at least one confactor containing X that is applicable in context c.

For probabilistic inference, where we will normalise at the end, we can remove any confactor that doesn't involve any variable (i.e., with an empty context and single number as the table) as a result of the second or third cases. That is, we remove any confactor that only has observed variables. We then need to replace "equal" with "proportional" in the program invariant.