that the elimination ordering has to be given a priori. The other choice points are the order in which to do multiplication, and the splitting ordering.

Note that in the *eliminate* algorithm, all set operations are assumed to be on multisets. It is possible, and not uncommon, to get multiple copies of the same confactor. One example where this happens is when there is a naive Bayes model with variable C with no parents, and variables Y1, . . . , Yn each with only C as a parent. Often the conditional probabilities of some of the Yi's are the same as they represent repeated identical sensors. If these identical sensors observe the same value, then we will get identical confactors, none of which can be removed without affecting the answer.

To see the correctness of the procedure, note that all of the local operations preserve the program invariants; we still need to check that the algorithm halts. After the first while-loop of eliminate, the contexts of the confactors in R
∗are mutually exclusive and covering by the second part of the loop invariant. For all complete contexts on the variables that remain after Y is eliminated, there is either a compatible confactor with Y in the table, or there is a compatible confactor with Y = vi for every value vi. The splitting of the second while loop of eliminate preserves the mutual exclusiveness of the bodies of the confactors in R
∗and when splitting a confactor, the set of created confactors covers the same context as the original confactor. If there are confactors in R
∗, and the if-condition does not hold, then there must be a pair of confactors where the else-if condition holds. Thus, each time through the second while-loop, the number of confactors in R
− increases or the number of confactors in R
∗increases and these are both bounded in size by the size of the corresponding factor. Thus eliminate must stop, and when it does Y is eliminated in all contexts.

## 4.10 Ones

In a Bayesian network we can remove a non-observed, non-query node with no children without changing the conditional probability of the query variable. This can be carried out recursively. In VE, if we were to eliminate such variables, we create factors that are all ones (as X P(X|Y) = 1).

In contextual VE, we can have a more subtle version when a variable may have no children in some contexts, even if it has children in another context.

Example 19 Consider eliminating B as in Example 14 where the belief network is given in Figure 1 and the structured conditional probabilities are given in Figure 3). In the context a ∧ c, the only confactors that are applicable are those that define P(B|YZ). As stated, the contextual VE algorithm, the following three confactors are created:
-a ∧ c ∧ y, 1[Z]
-a ∧ c ∧ y, 1 where 1[Z] is a function of Z that has value 1 everywhere and 1 is the function of no variables that has value 1.

Confactors that have contribution 1 can be removed without affecting the correctness of the algorithms (as long as these confactors aren't the only confactors that contain a variable in some context). It is easy to show that the first part of the program invariant is maintained as multiplying by 1 doesn't affect any number. The second part of the invariant is also maintained, as there are always the confactors for the child (E in this case) that don't depend on the variable being eliminated, as well as the confactors for the parents of the variable being eliminated.