initial and intermediate factors created in VE. The parents in the tree of any factor are those factors that were multiplied or had a variable summed out to produce this factor. Note that this is a tree
(each factor has only one child) as each factor is only used once in VE; once it is multiplied or a variable is summed from it, it is removed.

For each node in this tree that is created by multiplying two other factors, the number of multiplications in VE is equal to the table size of the resulting factor. For each factor created by summing out a variable, the number of additions is equal to the size of its parent minus its size.

We can define tree-based variable elimination (TVE) to be a composite of VE and CVE. It uses confactors as in CVE. Associated with each factor in the VE derivation tree is a set of confactors.

WhenVE multiplies two factors, TVE multiplies (and does the requisite splitting) all of the compatible confactors associated with the factors being multiplied. TVE is essentially the same as the tree-based merging of Boutilier (1997) (but Boutilier also does maximization at decisions).

Whenever VE multiplies two factors, TVE multiplies all of the confactors associated with the factors. The TVE confactors associated with the VE factors will always have a total table size that is less than or equal to the VE factor size. TVE maintains a set of confactors with mutually exclusive and covering contexts. The number of multiplications is equal to the resulting table size for each pairwise multiplication (as each entry is computed by multiplying two numbers). It is easy to see that TVE always does fewer or an equal number of multiplications than VE.

CVE is like TVE except that CVE doesn't multiply some of the confactors when VE multiplies two factors. It delays the multiplications until they need to be done. It relies on the hope that the confactors can be separately simplified before they need to be multiplied. This hope is not unjustified because if eliminating a variable means that both of the factors need to be multiplied by other confactors, then they need to be multiplied by each other.

Example 21 If we were to use TVE for Example 20, once OT is eliminated, TVE builds a tree representing the probability on both FH and MH. This entails multiplying out the confactors that were not combined in CVE, for example multiplying the third, fifth and sixth factors of the result of Example 20, which produces the confactor of the form f b ∧ mb, t(FH, FT, MH, MT, S). Eliminating OT results in a set of confactors with total table size 72, compared to 24 for VE. Without any contextual structure, VE builds a table with 27 = 128 values.

It is possible that not multiplying compatible confactors earlier means that we will eventually have to do more multiplications. The following example is the simplest example we could find where CVE does more multiplications than VE or TVE. Slight variations in the structure of this example, however result in CVE doing fewer multiplications.

Example 22 Consider the belief network shown in Figure 8(a). First we will sum out a variable, A,
to create two confactors that are not multiplied in CVE but are multiplied in TVE. We then multiply one of these confactors by another factor when summing out the second variable, B. We then force the multiplication when eliminating C.

Suppose that all of the variables are binary except for variable W that has domain size 1000. (The counter example doesn't rely on non-binary variables; you could just have B having 10 binary parents, but this makes the arithmetic less clear). In the analysis below we only discuss the multiplications that involve W, as the other multiplications sum up to less than a hundred, and are dominated by the multiplications that involve W.

Suppose that we have the following confactors for S:
-x, t1(A, B,C, S) (38)