When C is eliminated, TVE requires no more multiplications. It just sums out C from the table of confactor (48). However in CVE, we need to multiply confactors (43) and (47), which involves 4000 multiplications. The resulting confactors from CVE and TVE are identical.

Thus CVE requires about 20000 multiplications, TVE requires about 16000 multiplications. VE,
for the same elimination order, requires about 16000 multiplications.

This should not be surprising, particularly when you realise that VE is not optimal. For a given elimination ordering, it is sometimes optimal to multiply factors before VE actually multiplies them, as the following example shows: Example 23 Consider the belief network in Figure 8(b), with the same domain sizes as in the previous example. The factors represent P(W), P(B|W), P(C), P(S|BC). If we were to eliminate B
then C, it is more efficient to preemptively multiply P(C) by P(S|BC)than to delay the multiplication till after summing out B (as VE does).

It may seem negative to show that CVE doesn't always do fewer multiplications than VE but has the overhead of maintaining contexts. However, there seems no reason why the preemptive multiplication of TVE is optimal either. One possibility is to treat "when to multiply" and "when to sum out variables" as a secondary optimisation problem (Bertelè and Brioschi, 1972; Shachter et al., 1990; D'Ambrosio, 1995); unfortunately this optimization is also computationally difficult (D'Ambrosio, 1995). This, however is beyond the scope of this paper.

## 5. Avoiding Splitting 5.1 Absorption

In this section we characterize a case when we don't need to split during multiplication. Note that the result of eliminating a variable is exactly the same as before; we are saving because we don't create the residuals, but rather use the original confactor.

Definition 15 A multiset of confactors R is **complete** if the contexts of the confactors are mutually exclusive and covering.

If we have a multiset R of confactors that is complete, it means that we don't have to split other confactors r that may need to be multiplied by all of the confactors in R. For each residual of r, there will be another element of R with which it will be compatible. Instead of splitting r, we can just multiply it by each element of R. This is the intuition behind absorption. Note that we may need to split elements of R during multiplication.

Suppose we have a complete multiset of confactors R and another confactor r1 = -c1, t1. Define absorb(R,-c1, t1)
= {-ci, pi ∈ R : *incompatible*(ci, c1)}
∪
-ci, ti ∈ R
compatible(c1, ci)
(*residual*(-ci, ti, c1) **∪ {-**c1 ∪ ci,set(t1, ci) ⊗t set(ti, c1)})
where ⊗tis table multiplication (Definition 3).