Correctness: We can replace R ∪ {r1} with *absorb*(R,r1) and the program invariant is preserved. First note that the confactors in *absorb*(R,r1) are complete (and so the second part of the invariant holds). To see why the first part of the invariant is preserved, consider a complete context c. If c is compatible with c1, then in the original confactors, we use one confactor from R as well as r1. In the revised confactor base we use the appropriate confactor with the product of the original probabilities. If c is incompatible with c1 then it is compatible with one element -c2, p2 of R. If c2 is incompatible with c1, the confactor to be used is the original confactor, and if c2 is compatible with c1, then we use the residual confactor. In each case we get the same contributions from R∪ {r1} and from *absorb*(R,r1).

Example 24 If we were to eliminate B from the confactors of Figure 4 (as in example 14), we can treat the two confactors for P(B|Y, Z) as the complete multiset of confactors. This means that we don't need to split the other confactors on Y.

Note that if we try to use the confactors for E as the complete set of confactors when eliminating B, we don't have to split the confactors on A, C or D, but we have to consider confactors that don't involve B when eliminating B, and we end up multiplying confactors that don't need to be multiplied.

Note that if R cannot be represented as a decision tree (e.g., if R has confactors corresponding to the contexts in {{a, b},{a, c},{b, c},{a, b, c},{a, b, c}}), it's possible that there is no way to split r1 that results in as compact a representation as results from *absorb*(R,r1).

It seems as though it is very useful to have a multiset of confactors that is complete, but it is not of much use if we cannot easily find such a set. First note that if we have a multiset R of confactors that is complete, then *absorb*(R,r1) is also a multiset of confactors that is complete, which can, in turn, be used to combine with another confactor.

Initially, for each variable X, the confactors that represent the conditional probability table P(X|πX) are complete. Moreover they will all contain X and so need to be involved when eliminating X. These can be used as the initial seed for absorbing other confactors. Unfortunately, after we have eliminated some variables, the confactors that define the initial conditional probability tables for some variable X don't exist anymore; they have been split, multiplied by other confactors and added to other confactors. However, for each variable X, we can still extract a useful multiset of confactors that all contain X that are complete on the empty context (i.e., are mutually exclusive and covering).

These will be called the **confactors for** X, and correspond to the confactors with X in the head in an earlier version of contextual variable elimination (Poole, 1997).

Definition 16 If X is a variable, the **confactors for** X are a subset of the confactor base defined by:
- Initially the confactors for X are the confactors that define the conditional probability P(X|πX).

- When we split a confactor for X, the confactors created are also confactors for X. Note that this does not cover the case where we are splitting a confactor on a confactor for X.

- When we multiply a confactor for X with another confactor, the confactor created is a confactor for X.

- When we add a confactor for X with another confactor (when eliminating another variable Y,
for example), the resulting confactor is also a confactor for X.
Proposition 2 The confactors for X at any stage of contextual variable elimination are complete.