To show this, we will show that the three basic operations preserve this property.

- splitting preserves this property, as the resulting confactors are exclusive and cover the context of the confactor being split.

- multiplication preserves this property as, for any variable X, only one of the confactors involved in a multiplication can be a confactor for X (as the confactors for X are mutually exclusive) and the set of contexts covered by the confactors isn't changed by multiplication. This argument also holds for absorption.

- for addition, note that, for any variable X, either all of the confactors or none of the confactors involved in an addition are confactors for X when summing out Y. To show this suppose we have r1 = -c ∧ Y = v1, p1 and r2 = -c ∧ Y = v2, p2 where confactor r1 is a confactor for X and confactor r2 isn't. Because the confactors for X are mutually exclusive and covering, there must be a confactor that is covered by X that is applicable in a context when c ∧ Y = v2 is applicable. This confactor cannot mention Y, for otherwise addition isn't applicable, and so it must also be applicable when c ∧ y = v1 is true, which contradicts the mutual exclusiveness of the confactors for X. Now it is easy to see that addition preserves this property as the confactors being summed cover the same contexts as the resulting confactor.
We can also use the idea of the confactors for X to recognise when summing out a variable will create a table of 1's that can be removed (see Section 4.10). First note that in the original confactors for X, if, when eliminating X, we don't have to multiply these by other confactors (i.e., they have no children in this context), then we know that summing out X will produce a table of 1's. We can do better than this for recognising when we will produce ones. We will use one bit of information to encode whether a confactor for X is *pure* for X. Initially all of the confactors for X are pure for X. If a confactor for X is pure for X, and, when eliminating Y is absorbed into a confactors for Y
that is pure for Y, then the resulting confactor is pure for X. For every other case when a confactor for X is multiplied by another confactor, the result is not pure for X. If we are summing out X, after absorption, we can remove all confactors for X that are pure for X. This is correct because we have maintained the invariant that if we sum out X from the table of a confactor for X that is pure for X we create a table with only ones. Note that this procedure generalises the idea that we can recursively remove variables with no children that are neither observed nor queried.

The idea of absorption into the rules for the variable being eliminated described in this section should only be seen as a heuristic to avoid splitting. It does not necessarily reduce the amount of work. First note that in variable elimination there is a choice in the order that we multiply factors. Multiplication of factors is associative and commutative, however, the order in which the multiplication is carried out affects efficiency, as the following example shows. Example 25 Suppose variable B has one parent, A and two children C and D, who each only have B as a parent. When eliminating B we have to multiply the factors representing P(B|A), P(C|B)
and P(D|B). Suppose that B, C and D are binary, and that A has domain size of 1000. When multiplying two factors the number of multiplications required is equal to the size of the resulting factor. If we save intermediate results, and multiply these in the order(P(B|A)⊗t P(C|B))⊗t P(D|B),
we will do 12000 multiplications. If we save intermediate results, and multiply these in the order P(B|A) ⊗t (P(C|B) ⊗t P(D|B)), we will do 8008 multiplications. If we don't save intermediate tables, but instead recompute every product, we will do 16000 multiplications.