list of the confactors (for each variable, we have a list of all of the confactors that are for that variable and a list of the confactors that contain that variable). We then have to maintain these lists as we create new confactors and delete old ones. We also want to be able to index the confactors so that we can quickly find other confactors that contain the variable to be eliminated and have compatible contexts. In our implementation, we compared all of the confactors that contain the variable to be eliminated, and rejected those with incompatible contexts. Ideally, we should be able to do better than this, but how to do it is an open question.

There are a number of choice points in this algorithm:
- the elimination ordering. - the splitting ordering; when computing residuals, which order should the variables be split on.

This is discussed in Section 4.4.

- the order that the elements of R
∗are absorbed. This has an impact similar to the choice of multiplication ordering for VE (when we have to multiply a number of factors, which order should they be done); sometimes we can have smaller intermediate factors if the choice is done appropriately.

## 6. Empirical Results

An interesting question is whether there are real examples where the advantage of exploiting contextual independence outweighs the overhead of maintaining confactors.

We can easily generate synthetic examples where VE is exponentially worse than contextual variable elimination (for example, consider a single variable with n, otherwise unconnected, parents, where the decision tree for the variable only has one instance of each parent variable, and we eliminate from the leaves). At another extreme, where all contexts are empty, we get VE with very little overhead. However, if there is a little bit of CSI, it is possible that we need to have the overhead of reasoning about variables in the contexts, but get no additional savings. The role of the empirical results is to investigate whether it is ever worthwhile trying to exploit context-specific independence, and what features of the problem lead to more efficient inference.

## 6.1 A Pseudo-Natural Example

While it may seem that we should be able to test whether CVE is worthwhile for natural examples by comparing it to VE for standard examples, it isn't obvious that this is meaningful. With the tablebased representations, there is a huge overhead for adding a new parent to a variable, however there is no overhead for making a complex function for how a variable depends on its existing parents. Thus, without the availability of effective algorithms that exploit contextual independence where there is a small overhead for adding a variable to restricted contexts, it is arguable that builders of models will tend to be reluctant to add variables, but will tend to overfit the function for how a variable depends on its parents. As all models are approximations it makes sense to consider approximations to standard models. As we are not testing the approximations (Dearden and Boutilier, 1997; Poole, 1998), we will pretend these are the real models.

In this section we produce evidence that there exists networks for which CVE is better than VE. The sole purpose of this experiment it to demonstrate that there potentially are problems where it is worthwhile using CVE. We use an instance of the *water* network (Jensen, Kjærulff, Olesen