To compute P(X|E1=o1 ∧ . . . ∧ Es=os)
Let F be the factors obtained from the original conditional probabilities.

1. Replace each f ∈ F that involves some Ei with f{E1=o1,...,Es=os}.

2. While there is a factor involving a non-query variable Select non-query variable Y to eliminate Set F = *eliminate*(Y,F).

3. Return *renormalize*(F)
Procedure *eliminate*(Y,F):
Partition F into
{f1, . . . , fm} that don't contain Y and
{fm+1, . . . , fr} that do contain Y
Compute f =Y
fm+1 ⊗t. . . ⊗tfr Return {f1, . . . , fm, f}
Procedure *renormalize*({f1, . . . ,fr}):
Compute f = f1 ⊗t. . . ⊗tfr Compute c =X
f % c is normalizing constant Return f /c % divide each element of f by c Figure 2: The tabular VE algorithm where f1 . . . fm are those functions that don't involve Yi, and fm+1 . . . fk are those that do involve Yi.

We explicitly construct a representation for the new function Yi fm+1 . . . fk , and continue summing out the remaining variables. After all the Yi's have been summed out, the result is a function on X
that is proportional to X's posterior distribution.

In the tabular implementation of the VE algorithm (Figure 2), a function of d discrete variables V1, . . . , Vd, is represented as a d-dimensional table (which can be implemented, for example, as a d-dimensional array, as a tree of depth d, or, as in our implementation, as a 1-dimensional array based on a lexicographic ordering on the variables). If f is such a table, let *variables*(f) = {V1, . . . , Vd}.

We sometimes write f as f [V1, . . . , Vd] to make the variables explicit. f is said to *involve V*iif Vi ∈ *variables*(f).

There are three primitive operations on tables: setting variables, forming the product of tables, and summing a variable from a table.

Definition 2 Suppose C is a set of variables, c is an assignment C = v, and f is a factor on variables X. Let Y = X − C, let Z = X ∩ C, and let Z = v
′ be the assignment of values to Z that assigns the same values to elements of Z as c does. Define set(f, c) be the factor on Y given by:

## Set(F, C)(Y) = F(Y, Z=V ′).

That is, set(f, c) is a function of Y, the variables of f that are not in c, that is like f, but with some values already assigned. Note that, as a special case of this, if c doesn't involve any variable in f then set(f, c) = f.

Example 2 Consider the factor f(A, B, C, D, E) defined by the table of Figure 1. Some examples of the value of this function are f(a, b, c, d, e) = 0.55, and f(a, b, c, d, e) = 1 − 0.08 = 0.92.

set(f , a ∧ b ∧ e) is a function of C and D defined by the table: