
## 3. Contextual Independence

In this section we give a formalization of contextual independence. This notion was first introduced into the influence diagram literature (Smith et al., 1993). We base our definitions on the work of Boutilier et al. (1996).

Definition 5 Given a set of variables C, a **context** on C is an assignment of one value to each variable in C. Usually C is left implicit, and we simply talk about a context. We would say that C are the variables of the context. Two contexts are **incompatible** if there exists a variable that is assigned different values in the contexts; otherwise they are **compatible**. We write the empty context as *true*.

Definition 6 (Boutilier et al., 1996) Suppose X, Y, Z and C are sets of variables. X and Y are contextually independent given Z and context C=c, where c ∈ dom(C), if P(X|Y=y1 ∧ Z=z1 ∧ C=c) = P(X|Y=y2 ∧ Z=z1 ∧ C=c)
for all y1, y2 ∈ dom(Y) for all z1 ∈ dom(Z) such that P(Y=y1 ∧ Z=z1 ∧ C=c) > 0 and P(Y=y2 ∧
Z=z1 ∧ C=c) > 0.

We also say that X is **contextually independent** of Y given Z and context C=c. Often we will refer to the simpler case when the set of variables Z is empty; in this case we say that X and Y are contextually independent given context C=c.

Example 4 Given the belief network and conditional probability table of Figure 1,
- E is contextually independent of {C, D, Y, Z} given context a ∧ b. - E is contextually independent of {C, D, Y, Z} given {B} and context a.

- E is not contextually independent of {C, D, Y, Z} given {A, B} and the empty context *true*.

- E is contextually independent of {B, D, Y, Z} given context a ∧ c. - E is contextually independent of {A, B, C, D, Y, Z} given B and context a ∧ c ∧ d.

## 3.1 Where Does Contextual Independence Arise?

Most of the examples in this paper are abstract as they are designed to show off the various features of the algorithms or to show pathological cases. In this section we will give some examples to show natural examples. We are not claiming that contextual independence is always present or able to be exploited. Exploiting contextual independence should be seen as one of the tools to solve large probabilistic reasoning tasks. Example 5 When a child goes into an emergency ward the staff may want to determine if they are a likely carrier of chicken pox (in order to keep them away from other children). If they haven't been exposed to chicken pox within the previous few weeks, they are unlikely to be a carrier. Thus whether they are a carrier is independent of the other background conditions given they haven't been exposed. If they have been exposed, but have not had chicken pox before they are likely to be a carrier. Thus whether they are a carrier is independent of the other background conditions given they have been exposed and haven't had chicken pox before. The other case can involve many other variables (e.g., the severity and the age of the last time they had chicken pox) to determine how likely the child is to be a carrier.