Example 6 Many engineered systems are designed to insulate something from other conditions. The classic example is central air conditioning (heating and/or cooling in a house). The temperature inside a house depends on the outside temperature if the air conditioning is off. If the air conditioning is on, the temperature depends on the setting of the thermostat and not on the outside temperature. Thus the inside temperature is contextually independent of the outside temperature given the air conditioning is on and is contextually independent of the thermostat setting given the air conditioning is off.

Example 7 Consider a case where someone is to make a decision based on a questionnaire and the questions asked depend on previous answers. In this case the decision6is contextually independent of the answers to the questions that are not asked given the context of the questions asked. For example, consider a questionnaire to determine if a bank customer should get a loan that starts asking the customer if they rent or own their current home. If they own, they are asked a number of questions about the value of the house which are not asked if they rent. The probability that they get a loan is contextually independent of the value of the home (and the other information that was not available to the decision maker) given that the applicant rents their home. Example 8 When learning a decision network from data, it is often advantageous to build a decision tree for each variable given its parents (Friedman and Goldszmidt, 1996; Chickering, Heckerman and Meek, 1997). These decision trees provide contextual independence (a variable is independent of it's predecessors given the context along a path to a leaf in the tree). The reason that this is a good representation to learn is because there are fewer parameters and more fine control over adding parameters; splitting a leaf adds many fewer parameters than adding a new parent (adding a new variable to every context).

## 3.2 Parent Contexts And Contextual Belief Networks

We use the notion of contextual independence for a representation that looks like a belief network, but with finer-grain independence that can be exploited for efficient inference in the contextual variable elimination algorithm.

As in the definition of a belief network, let's assume that we have a total ordering of the variables, X1, . . . , Xn.

Definition 7 Given variable Xi, we say that C=c, where C ⊆ {Xi−1 . . . X1} and c ∈ dom(C), is a parent contextforXiifXiis contextually independent of the predecessors ofXi (namely {Xi−1 . . . X1})
given C=c.

What is the relationship to a belief network? In a belief network, the rows of a conditional probability table for a variables form a set of parent contexts for the variable. However, there is often a much smaller set of smaller parent contexts that covers all of the cases.

Example 9 Consider the belief network and conditional probability table of Figure 1. The predecessors of variable E are A, B, C, D, Y, Z. A set of minimal parent contexts for E is {{a, b}, {a, b},
{a, c}, {a, c, d, b}, {a, c, d, b}, {a, c, d}}. This is a mutually exclusive and exhaustive set of parent contexts. The probability of E given values for its predecessors can be reduced to the probability of