Figure 7: A bi-partite network of twenty nodes in each layer.  Each child node (bottom

![0_image_0.png](0_image_0.png)

layer) has three parents in the top layer and each parent node has exactly three children.  Probability tables were randomly initialized from a uniform distribution.

The shaded nodes in the bottom layer are clamped to a certain state. The bound propagation algorithm ran with Ω(2500) and converged in 37 seconds. For each node the thick horizontal lines show their exact marginals, the top and bottom of the rectangle are the upper and lower bounds found.

For small Ising grids computing the exact marginals is tractable, but as soon as the grid is larger than about 25 by 25 the exact algorithm fails due to the exponential scaling of the computational complexity.  The bound propagation algorithm, on the other hand, only depends on the local structure (i.e. the size of the Markov blankets of each node)
and thus scales linearly with the number of nodes. We created an 40x40 Ising grid with binary nodes similarly as above and ran the bound propagation algorithm. For this network the exact algorithm would require a storage capacity of at least 2 41 real numbers, whereas bound propagation converged in about 71 minutes in which time it computed bounds on the marginals over all 1600 nodes.

In Figure 6 we show the 40x40 grid where the blackness of the squares correspond to the band width of the single node marginals. This band width is defined as the difference between the upper and lower bound. Due to the fact that marginal probabilities sum to one, the two band widths for these binary neurons are identical. We can clearly see some regions in the lattice (the blacker area's) for which bound propagation had some difficulties. Most of the marginals, however, are bounded quite well: more than 75% had a band width less than 0.1.

## 5.3 The Bi-Partite Graph

A bi-partite graph is a network consisting of two layers of nodes, where the top layer is hidden and the bottom layer visible. The only connections in the network are from the top layer (parent nodes) to the bottom layer (child nodes).  Such a architecture appears very simple, but already with several tens of nodes it is often intractable to compute the marginals exactly when evidence is presented. A bi-partite graph can be undirected or directed (pointing downwards). A recent example of the first is the POE (product of experts) from Hinton (1999) with discrete nodes.  The 'Quick Medical Reference' (QMR) network from Shwe et al. (1991) is a good example for a directed bi-partite graph. Recently there were