for the bound propagation algorithm. The bounds can easily be improved by enlarging the clusters as we saw in Figure 3.

Close to the fixed point the bound propagation algorithm converges exponentially. The distance to the asymptotic value can be written as a n , where n is the number of iterations and α is a number between zero and one indicating the convergence speed. The closer to one α is, the slower the algorithm converges. In Figure 4b α is shown for the same weights and thresholds. It is clear that larger weights induce a slower convergence. That is what we see in general: probabilities that are close to deterministic slow down the convergence.

## 5. Real World Networks

To assess the quality of the bound propagation algorithm for more challenging networks, we computed bounds for a Bayesian network (Section 5.1), that is commonly used in articles as a representative of a real world problem. Secondly, we show that the bound propagation method can be used to find many tight bounds for a large Ising grid (Section 5.2 and finally, in Section 5.3, we show results for a bi-partite graph. For these networks, we will briefly discuss bound propagation in relation with the cluster variation method (Kappen & Wiegerinck, 2002) which is one of the better approximation methods for general graphs.

Whenever possible, we show the exact marginals.

## 5.1 The Alarm Network

The Alarm network 3 is a commonly used network which is a representitive of a real life Bayesian network. It was originally described by Beinlich et al. (1989) as a network for monitoring patients in intensive care. It consists of 37 nodes of two, three or four states and is small enough to do exact computations. In Figure 5 the graphical model is shown.

Our task was to determine the single node marginals in absence of any evidence. For each node the exact marginal probabilities for its states are shown as horizontal lines. The top and bottom of the rectangles around these lines indicate the upper and lower bounds respectively. For this network we used Ω(25,000) 4 . If we make this choice, we can treat exactly the minimal Markov blanket of all single node marginals. The algorithm converged in about six minutes.

We see that the bounds in the lower left corner are very close to the exact value. We can give some intuition why this happens. Observe that node 7 on its own can play the role of separator for nodes 1 to 6. Thus all correlations between these nodes and the rest of the network are through node 7, which means that their uncertainty only depends on the uncertainty of node 7. The latter happens to be very small (consider that as a given fact) and therefore the marginal bounds for nodes 1 to 6 are very tight.

The bounds in the upper right corner, on the other hand, are quite poor.  This is partially due to the density of the connections there and the number of states each of the nodes has. In combination this leads to large state spaces already for small clusters. Therefore, we cannot compute bounds on sets of multiple nodes, which generally leads to weaker bounds.