The value function for succinct MDPs is defined by simply replacing s
′ ∈ S **with "**s
′is a propositional interpretation over V."
If the MDP and the policy are succinctly represented, the value function cannot necessarily be represented explicitly in polynomial space. Rather, some form of succinct representation is employed, usually by decomposition of the state space (for example, by grouping states with the same expected reward.) As it has already been **done for policies, value** functions are succinctly represented by circuits. Definition 6 A succinct value function is a circuit E whose inputs are a state s **and an** integer i and whose output is the expected reward of s at i **points before the horizon.**
Given a policy P**, there always exists an associated value function, which gives the**
expected reward that can be obtained from the state by executing the actions as specified by the policy. The converse, however, is not always possible. Some value functions, indeed, do not correspond to any policy. While any value function can **be used to derive a policy** by selecting the actions that maximize the expected reward of the resulting states (this is how value functions are often used), some value functions are completely unrelated to the actual expected reward of states. As an example, if the reward of s0 **is 0, and no action**
changes the states (i.e., t(s, s, a) = 1 for all actions a and states s**), then the value function**
E such that E(s0, T**) = 1000 does not correspond to any policy. In other words, some value**
functions assign expected rewards to states in a way that is not consistent with the MDP,
i.e., there is no way to obtain such a reward by executing whichever actions. Therefore, a value function may or may not be consistent, according to the **following definition.**
Definition 7 A value function E is consistent with an MDP M and horizon T **if and only**
there exists a policy P such that E is the value function of M, T**, and** P.

An interesting property of value functions is that, in some cases, they actually represent policies. Indeed, a policy can be determined from a value function in polynomial time if the degree of non-determinism is bounded, and a list of possible **states that may result from**
executing an action can be calculated in polynomial time. In **particular, the set of states**
resulting from applying a in s **are assumed to be the result of a circuit** na.

Definition 8 A bounded-action MDP is a 6-tuple M = hV, s0, A, N , t, ri**, where** M′ =
hV, s0, A, t, ri is a succinct MDP and N = {na} is a set of circuits, one na ∈ N **for each**
a ∈ A, such that na(s) **is the list of states** s
′such that t(s, s′, a) > 0.

Beside N **, the definition of bounded-action MDPs is the same as that of succinct MDPs.**
The difference can be explained in two ways: intuitively, it is assumed that the possible outcomes of actions can be determined in time polynomial in the size of the MDP; technically, the time needed to determine the possible states that **result from applying an action**
is included in the size of the input.

The proof of NPPP**-hardness of the problem of policy existence only uses bounded-action**
MDPs, and therefore still holds in this case. This seems to contradict the intuition that a large degree of non-determinism is one of the sources of complexity of problems on MDPs. The next results will explain this contradiction.