Given a bounded-action MDP M, a horizon, and a succinct value function E**, we can**
identify in polynomial time a succinct policy that corresponds to E**, that is, a policy that**
leads to the expected reward of states as specified by E**. For the case of stationary policies,**
P is determined as follows: for a given state s, we consider an action a **and a time point** i, and check whether the result of executing a **is consistent with the value function, assuming**
that the time point is i. This is done by determining the sum of t(s, s′, a) · E(s
′, i − **1). If**
this is equal to E(s, i) − r(s), then the action a is the action to execute, i.e., P(s) = a**. The** whole process is polynomial, that is, P(s**) can be determined in polynomial time.**
If E **is consistent with an MDP, then there are policies for which the expected reward**
of each state s is E(s). As a result, a consistent value function E **represents a group of** policies, all having the same expected reward. It therefore **makes sense to consider the** problem of finding E rather than finding P**. More precisely, since only decision problems**
are considered, the analyzed problem is that of checking whether there exists E **such that** the expected reward of the corresponding policies is greater than or equal to a given number.

Given E, the expected reward is simply given by E(s0, T**). In order to check whether such**
a reward can actually be obtained from the MDP, however, we also have to check whether the value function E **is consistent with the MDP. This is the point where the assumption**
that the set of actions of a succinct MDP is not in a succinct representation is used.

Theorem 8 Checking whether a succinct value function E is consistent with a boundedaction MDP and a horizon in unary is coNP**-complete, both for stationary and historydependent policies.**
Proof. The problem is to check whether there exists a policy P **that gives an expected**
reward as specified by E. Namely, for all s and i**, we have to check whether the equation**
in Definition 5 holds for some policy P**. In turn, the existence of a policy means that, for** each s, there exists an associated action a that satisfies the equation when P(s**) is replaced**
by a.

Formally, let M = hV, s0, A, t, ri be the MDP, T be the horizon, and S **be the set of**
interpretations over the alphabet V**. The condition can be formally expressed as follows.**
For every state s, it holds that E(s, 0) = r(s**), and:**

$\forall s\in\mathcal{S}\ \ \exists a\in\mathcal{A}\ \ \forall i\in\{1,\ldots,T\}\.\ E(s,i)=r(s)+\sum_{s^{\prime}\in\mathcal{S}}t(s,s^{\prime},a)\cdot E(s,i-1).$
This condition contains three alternating quantifiers; however, the second one ranges over a ∈ A, while the third one ranges over i = {1, . . . , T}**. In both cases, the number of**
possibilities is polynomial in the size of the MDP and the horizon.

$$\forall s\ .\ \bigvee_{a\in{\mathcal{A}}}\ \ \bigwedge_{i=1,\ldots,T}\left(E(s,i)=r(s)+\sum_{s^{\prime}\in{\mathcal{S}}}t(s,s^{\prime},a)\cdot E(s^{\prime},i-1)\right).$$

The number of terms s
′ ∈ S **in the sum is not, in general, polynomial. The bounded**
action assumption, however, implies that the only states that are relevant are those s
′**that**
belongs to na(s**), i.e.,** s
′is one of the elements of the list produced by the circuit na **when**
s **is given as its input.**