there exists a policy with reward 1 if and only if there exists a model over X **whose extensions**
all satisfy Q.

This theorem shows that checking the existence of a succinct **value function of a given**
size and reward is in a complexity class in the second level of **the polynomial hierarchy for** bounded-action MDPs. The corresponding problem for policies (instead of value functions)
remains NPPP**-hard for bounded-action MDPs. Assuming that Σ**p 2 6= NPPP**, checking the**
existence of bounded-size succinct policies is harder than **checking the existence of value**
functions, in the sense that more problems can be polynomially reduced to the latter problem than to the former. Let us consider this result.

1. The problem is easier because of the additional constraint on the size of the value function. Assuming Σp 2 6= NPPP**, this implies that there are succinct policies of size**
polynomial in that of the MDP whose value function cannot be expressed as a circuit of size polynomial in that of the MDP, for bounded-actions MDPs. Translating succinct value functions into succinct policies is instead always feasible in polynomial space for bounded-actions MDPs. Therefore, any succinct policy can be translated into a succinct value function of polynomial size (in the size of the policy, the MDP, and the horizon), while the inverse translation is not always polynomial in size.

2. Given that the amount of physical memory is always bounded, the problem that is solved by algorithms finding the value function (such as value iteration) is actually that of checking the existence of a succinct value function of bounded size. This problem is easier than the similar problem with no bound, in the sense that the first problem can be polynomially reduced to the former but not vice versa, provided that Σ
p 2 6**= NP**PP.
Roughly speaking, finding a bounded-size succinct value function is simpler than finding a bounded-size succinct policy, but solving the former problem may produce solutions that are worse, in term of the overall reward, than the solutions of the latter.

## 7. Exponential Bounds

In the previous sections, the size bounds have been assumed to be in unary notation. This assumption has been made because, if it is not feasible to store the unary representation of the size, it is not feasible to store a data structure of that size as well. The unary notation formalizes the informal statement that the policy should take an amount of space that is polynomial in the size of the instance.

Let us now consider the problem of checking the existence of a **policy of a bounded size**
and reward, where the bound on the reward is in binary notation: we are searching for a policy that can be exponentially larger than the MDP, but still of size bounded by a given number. This problem is of interest whenever an exponential **succinct policy is acceptable,** but still there is a limit on its size.

An important observation about circuits is that it is not necessary to consider circuits of arbitrary size. Indeed, any circuit with n inputs and m **outputs is equivalent to a circuit** of size m2 n. This is because any such circuit is equivalent to m **circuits, each having the**
same n inputs and one output. Any such circuit represents a Boolean **function, which can**