Without loss of generality, instances of problems are assumed to be strings. The length of a string x ∈ Σ
∗is denoted by ||x||. The cardinality of a set S **is instead denoted by** |S|.

A function g is called poly-time if there exists a polynomial p and an algorithm A **such**
that, for all x, the time taken by A to compute g(x) is less than or equal to p(||x||**). A**
function f is called poly-size if there exists a polynomial p such that, for all strings x**, it**
holds ||f(x)|| ≤ p(||x||); whenever the argument of such a function f **is a number, is is**
assumed to be in unary notation. These definitions extend to functions with more than one argument as usual.

Circuits are defined in the standard way. Whenever C is a circuit and s **is a possible**
assignment of its input gates, its output is denoted by C(s**) its output. The formal definition** of circuits is not important in this paper, as we take advantage of a well-known result in circuit complexity that relates poly-time functions with poly-size circuits. Informally, given a circuit and the value of its inputs, we can determine its output in polynomial time. A similar result holds in the other way around, that is, poly-time functions can be represented by means of circuits (Boppana & Sipser, 1990).

Formally, however, a poly-time function from strings to strings has a string of arbitrary length as argument, and a string of arbitrary length (in general) as output. Even considering only functions that have a binary output (i.e., a single bit), the input may be arbitrarily long. On the other hand, each circuit has a specified number of **input gates. This is why** the correspondence between poly-time functions and poly-size circuits is not one-to-one.

However, the following correspondence holds: for any poly-time function from strings to strings, there exists a uniform family of poly-size circuits {C0, C1, C2, . . .}, where Ci**is a**
circuit with i input gates that calculates the result of f on all strings of length i**; "uniform"**
means that that there exists a function that calculates Cifrom i **and runs in time that is**
bounded by a polynomial in the value of i.

As a result, the class P can be also defined as the set of problems that can be solved by a uniform family of circuits. By replacing the assumption of **the family to be uniform with**
that of Ci being of size polynomial in the value of i**, the definition gives the class P/poly.**
In this paper, the problem of whether all succinct MDPs have an optimal succinct policy of polynomial size is considered. Note that, for any given MDP, its succinct policies are circuits that take as input a state (or, a sequence of at most T **states). As a result, a policy** is a single circuit, not a family.

The question is given a (negative) answer using two different **proofs, based on different**
techniques: the first one is based on compilability classes (Cadoli, Donini, Liberatore, & Schaerf, 2002), while the second one employs standard complexity classes. The compilability classes have been introduced to characterize the complexity of intractable problems when some preprocessing of part of the data is allowed. The problems characterized in this way are those having instances that can be divided into two parts: one part is fixed **(known** in advance) and one part is varying **(known when the solution is needed.) The problem** of determining the action to execute in a specific state has this form: the MDP (with the horizon) is the part known in advance, as it describes the **domain; on the contrary,** the state is only determined once the previous actions have been executed. Compilability classes and reductions formalize the complexity of such problems when the first part can be preprocessed.