As is common in complexity theory, only decision problems are considered, i.e., problems whose solution is a single bit. Such problems are usually identified with languages (sets of strings): a language L ⊆ Σ
∗**represents the decision problem whose output is 1 for all** x ∈ L
and 0 for all x 6∈ L.

The problems whose instances are composed of two parts can be **formalized as languages**
of pairs (of strings): a language of pairs S **is a subset of Σ**∗ × Σ
∗**. In order to characterize**
these problems, the non-uniform compilability classes **have been introduced (Cadoli et al.,**
2002). These classes are denoted by k❀**C and read "nu-comp-C", where C is an arbitrary**
uniform complexity class, usually based on time bounds, such as P, NP, etc.

Definition 3 (k❀C classes) k❀C **is composed of all languages of pairs** S ⊆ Σ
∗ × Σ
∗**such**
that there exists a poly-size function f **from pairs to strings to strings and a language of**
pairs S
′ ∈ C such that, for all hx, yi ∈ Σ
∗ × Σ
∗**, it holds:**

## Hx, Yi ∈ S Iff Hf(X, ||Y||), Yi ∈ S ′

A problem is in k❀**C if it reduces to one in C after a suitable polynomial-size preprocessing (compiling) step. Any problem** S ⊆ Σ
∗ ×Σ
∗that is in C is also in k❀C (i.e., f(x, n) = x and S
′ = S**). Preprocessing is useful if a problem in C is in** k❀C
′ and C′ ⊂ **C: in this case,**
preprocessing decreases the complexity of the problem. Such a reduction of complexity is possible for some problems (Cadoli et al., 2002).

The tool used for proving that such a decrease of complexity is not possible is the concept of hardness with respect to compilability classes, **which is in turn based on a**
definition of reductions. Since these general concepts are not really needed in this paper, only the condition based on monotonic polynomial reductions is presented. This condition is sufficient to prove that a problem in k❀NP is not in k❀P unless NP ⊆ P/**poly, which is**
currently considered unlikely.

Let us assume that hr, hi **is a polynomial reduction from** 3sat **to a problem of pairs** S,
that is, r and h are poly-time functions and Π is satisfiable if and only if hr(Π), h(Π)i ∈ S.

This pair hr, hi **is a monotonic polynomial reduction if, for any pair of sets of clauses Π**1 and Π2 over the same literals, with Π1 ⊆ Π2**, it holds:**

## Hr(Π1), H(Π1)I ∈ S Iff Hr(Π2), H(Π1)I ∈ S

Note that the second instance combines a part from Π2 and a part from Π1**: this is**
intentional. Roughly speaking, such a reduction implies that the hardness of the problem S comes from the second part of the instances only, as the first part r(Π1**) of an instance**
that is the result of a reduction can be replaced by another one r(Π2**) without changing**
its membership to S. If the complexity of a problem is due to a part of the instance **only,** preprocessing the other part does not reduce the complexity **of the problem. The formal**
proof of the fact that the existence of such a reduction implies that S is not in k❀**P (unless**
NP ⊆ P/**poly) can be found elsewhere (Liberatore, 2001).**

## 4. Super-Polynomially Sized Policies

Suppose that it is always possible to find an optimal succinct policy P **of polynomial size.** Since succinct policies are circuits by definition, deciding the action to execute in a state is