# Compiling Causal Theories To Successor State Axioms And Strips-Like Systems

Fangzhen Lin flin@cs.ust.hk Department of Computer Science The Hong Kong University of Science and Technology Clear Water Bay, Kowloon, Hong Kong

## Abstract

We describe a system for specifying the effects of actions. Unlike those commonly used in AI planning, our system uses an action description language that allows one to specify the effects of actions using domain rules, which are state constraints that can entail new action effects from old ones. Declaratively, an action domain in our language corresponds to a nonmonotonic causal theory in the situation calculus. Procedurally, such an action domain is compiled into a set of logical theories, one for each action in the domain, from which fully instantiated successor state-like axioms **and STRIPS-like systems are then** generated. We expect the system to be a useful tool for knowledge engineers writing action specifications for classical AI planning systems, GOLOG systems, and other systems where formal specifications of actions are needed.

## 1. Introduction

We describe a system for generating action effect specifications from a set of domain rules and direct action effect axioms, among other things. We expect the system to be a useful tool for knowledge engineers writing action specifications **for classical AI planning systems,**
GOLOG systems (Levesque et al., 1997), and other systems where formal specifications of actions are needed.

To motivate, consider the language used by STRIPS (Fikes & Nilsson, 1971) for describing the effects of actions. Briefly speaking, an action is described in this language by a first-order formula, called its precondition that describes the condition under which the action is executable, an add list that enumerates the propositions that the action will make true when successfully executed in a situation, and a delete **list that enumerates the propositions that the action will make false when successfully executed in a situation. While the**
original STRIPS allowed the precondition and the elements of the two lists to be complex formulas, STRIPS actions now refer only to those whose precondition is given by a conjunction of atomic formulas and whose add and delete lists are lists of atomic formulas.

It is widely acknowledged that this language is inadequate for describing actions in the real world. One of the limitations, the one that we address in **this paper, is that with the** language, one has to enumerate all possible effects of an action, a difficult if not impossible task for complex domains. For example, given a large C program, it is hard to figure out the effects of changing the value of a pointer on the values of all other pointers in the program. However, the underlying principle is very simple: when the value of a pointer changes, the values of all other pointers that point to the same memory location change as well. Put another way, the direct effect of the action of changing the value of a pointer to x **is that the**