value of the pointer will be x**. The indirect or side effects of this action are those derived** from the constraint which says that if two pointers point to a **common location, then their**
values must be the same.

This idea of specifying the effects of actions using domain constraints is like "engineering from first principle", and has many advantages. First of all, **constraints are action independent, and work on all actions. Secondly, if the effects of actions derived from domain**
constraints agree with one's expectation, then this will be **a good indication that one has**
axiomatized the domain correctly. Finally, domain constraints can be used for other purposes as well. For instance, they can be used to check the consistency of the initial situation database. In general, when a set of sentences violates a domain constraint, we know that no legal situation can satisfy this set of sentences. This idea **can and has been used in planning** to prune impossible states. Recently, there have even been efforts at "reverse engineering" domain constraints from STRIPS-like systems to speed up planners (e.g. Zhang & Foo, 1997; Gerevini & Schubert, 1998; Fox & Long, 1998, and others).

While it is appealing to use domain constraints to derive the **indirect effects of actions,**
making the idea work formally turned out to be a challenge. The problem is commonly known as the ramification problem, and various proposals have been made to solve it. Until recently, however, these proposals were at best of theoretical interest only because of their high computational complexity. The situation has since changed substantially due to the use of causality in representing domain constraints (Lin, 1995, 1996; McCain & Turner, 1995, 1997; Thielscher, 1995, 1997; Baral, 1995; Lifschitz, 1997, and others). What we will describe in this paper is an implemented system that builds on this recent work on causalitybased approaches to the ramification problem. Specifically, **our system takes as input an**
action domain description where actions are described by their precondition axioms and direct effect axioms, and domain constraints are represented by what we call **domain rules**.

The system returns as output a complete action specification **both in STRIPS-like format** and as a set of fully instantiated successor state axioms (Reiter, 1991).

This paper is organized as follows. We begin by introducing our action description language. We then propose a procedure to compile an action domain specified in this language into a complete set of successor state axioms from which a STRIPS-like description is then extracted. We then show the soundness of this procedure with **respect to a translation from** action domain descriptions to situation calculus causal theories of Lin (1995). We next describe an implementation of this procedure, and present some experimental results. As one will see, one of the limitations of our system is that it is **essentially propositional. While** effect axioms and domain rules can have variables, they need to be fully instantiated during the compilation process. To partially overcome this limitation, we show some results that allow one to generalize the propositional output to the first-order case for certain classes of action domain descriptions. We then discuss some related work, and conclude this paper with some pointers for future work.

## 2. An Action Description Language

We assume a first-order language with equality. We shall call those predicates whose extensions may be changed by actions fluents**, and those whose extensions are not changed by**
any actions static relations. We also call unary static relations types. By **fluent atoms** we